/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateTargetFilterInputListCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateTargetInputFilter;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateTargetParameterMapCopier;
import software.amazon.awssdk.services.fis.model.ResourceArnListCopier;
import software.amazon.awssdk.services.fis.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExperimentTemplateTargetInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateExperimentTemplateTargetInput> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(CreateExperimentTemplateTargetInput.getter(CreateExperimentTemplateTargetInput::resourceType)).setter(CreateExperimentTemplateTargetInput.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceArns").getter(CreateExperimentTemplateTargetInput.getter(CreateExperimentTemplateTargetInput::resourceArns)).setter(CreateExperimentTemplateTargetInput.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resourceTags").getter(CreateExperimentTemplateTargetInput.getter(CreateExperimentTemplateTargetInput::resourceTags)).setter(CreateExperimentTemplateTargetInput.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ExperimentTemplateTargetInputFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(CreateExperimentTemplateTargetInput.getter(CreateExperimentTemplateTargetInput::filters)).setter(CreateExperimentTemplateTargetInput.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTemplateTargetInputFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SELECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selectionMode").getter(CreateExperimentTemplateTargetInput.getter(CreateExperimentTemplateTargetInput::selectionMode)).setter(CreateExperimentTemplateTargetInput.setter(Builder::selectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionMode").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(CreateExperimentTemplateTargetInput.getter(CreateExperimentTemplateTargetInput::parameters)).setter(CreateExperimentTemplateTargetInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_ARNS_FIELD, RESOURCE_TAGS_FIELD, FILTERS_FIELD, SELECTION_MODE_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExperimentTemplateTargetInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final List<String> resourceArns;
    private final Map<String, String> resourceTags;
    private final List<ExperimentTemplateTargetInputFilter> filters;
    private final String selectionMode;
    private final Map<String, String> parameters;

    private CreateExperimentTemplateTargetInput(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceArns = builder.resourceArns;
        this.resourceTags = builder.resourceTags;
        this.filters = builder.filters;
        this.selectionMode = builder.selectionMode;
        this.parameters = builder.parameters;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<ExperimentTemplateTargetInputFilter> filters() {
        return this.filters;
    }

    public final String selectionMode() {
        return this.selectionMode;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentTemplateTargetInput)) {
            return false;
        }
        CreateExperimentTemplateTargetInput other = (CreateExperimentTemplateTargetInput)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.selectionMode(), other.selectionMode()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExperimentTemplateTargetInput").add("ResourceType", (Object)this.resourceType()).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("SelectionMode", (Object)this.selectionMode()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "selectionMode": {
                return Optional.ofNullable(clazz.cast(this.selectionMode()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resourceArns", RESOURCE_ARNS_FIELD);
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("selectionMode", SELECTION_MODE_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExperimentTemplateTargetInput, T> g) {
        return obj -> g.apply((CreateExperimentTemplateTargetInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();
        private List<ExperimentTemplateTargetInputFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String selectionMode;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperimentTemplateTargetInput model) {
            this.resourceType(model.resourceType);
            this.resourceArns(model.resourceArns);
            this.resourceTags(model.resourceTags);
            this.filters(model.filters);
            this.selectionMode(model.selectionMode);
            this.parameters(model.parameters);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Map<String, String> getResourceTags() {
            if (this.resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapCopier.copy(resourceTags);
            return this;
        }

        public final List<ExperimentTemplateTargetInputFilter.Builder> getFilters() {
            List<ExperimentTemplateTargetInputFilter.Builder> result = ExperimentTemplateTargetFilterInputListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ExperimentTemplateTargetInputFilter.BuilderImpl> filters) {
            this.filters = ExperimentTemplateTargetFilterInputListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ExperimentTemplateTargetInputFilter> filters) {
            this.filters = ExperimentTemplateTargetFilterInputListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExperimentTemplateTargetInputFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExperimentTemplateTargetInputFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ExperimentTemplateTargetInputFilter)((ExperimentTemplateTargetInputFilter.Builder)ExperimentTemplateTargetInputFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSelectionMode() {
            return this.selectionMode;
        }

        public final void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public final Builder selectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ExperimentTemplateTargetParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ExperimentTemplateTargetParameterMapCopier.copy(parameters);
            return this;
        }

        public CreateExperimentTemplateTargetInput build() {
            return new CreateExperimentTemplateTargetInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateExperimentTemplateTargetInput> {
        public Builder resourceType(String var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder resourceTags(Map<String, String> var1);

        public Builder filters(Collection<ExperimentTemplateTargetInputFilter> var1);

        public Builder filters(ExperimentTemplateTargetInputFilter ... var1);

        public Builder filters(Consumer<ExperimentTemplateTargetInputFilter.Builder> ... var1);

        public Builder selectionMode(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

