/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fis.model.ExperimentError;
import software.amazon.awssdk.services.fis.model.ExperimentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ExperimentState.getter(ExperimentState::statusAsString)).setter(ExperimentState.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ExperimentState.getter(ExperimentState::reason)).setter(ExperimentState.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<ExperimentError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(ExperimentState.getter(ExperimentState::error)).setter(ExperimentState.setter(Builder::error)).constructor(ExperimentError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASON_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String reason;
    private final ExperimentError error;

    private ExperimentState(BuilderImpl builder) {
        this.status = builder.status;
        this.reason = builder.reason;
        this.error = builder.error;
    }

    public final ExperimentStatus status() {
        return ExperimentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String reason() {
        return this.reason;
    }

    public final ExperimentError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentState)) {
            return false;
        }
        ExperimentState other = (ExperimentState)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentState").add("Status", (Object)this.statusAsString()).add("Reason", (Object)this.reason()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentState, T> g) {
        return obj -> g.apply((ExperimentState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String reason;
        private ExperimentError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentState model) {
            this.status(model.status);
            this.reason(model.reason);
            this.error(model.error);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExperimentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final ExperimentError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ExperimentError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ExperimentError error) {
            this.error = error;
            return this;
        }

        public ExperimentState build() {
            return new ExperimentState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentState> {
        public Builder status(String var1);

        public Builder status(ExperimentStatus var1);

        public Builder reason(String var1);

        public Builder error(ExperimentError var1);

        default public Builder error(Consumer<ExperimentError.Builder> error) {
            return this.error((ExperimentError)((ExperimentError.Builder)ExperimentError.builder().applyMutation(error)).build());
        }
    }
}

