/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisClient;
import software.amazon.awssdk.services.fis.internal.UserAgentUtils;
import software.amazon.awssdk.services.fis.model.ListTargetAccountConfigurationsRequest;
import software.amazon.awssdk.services.fis.model.ListTargetAccountConfigurationsResponse;

public class ListTargetAccountConfigurationsIterable
implements SdkIterable<ListTargetAccountConfigurationsResponse> {
    private final FisClient client;
    private final ListTargetAccountConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTargetAccountConfigurationsIterable(FisClient client, ListTargetAccountConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTargetAccountConfigurationsResponseFetcher();
    }

    public Iterator<ListTargetAccountConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTargetAccountConfigurationsResponseFetcher
    implements SyncPageFetcher<ListTargetAccountConfigurationsResponse> {
        private ListTargetAccountConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetAccountConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTargetAccountConfigurationsResponse nextPage(ListTargetAccountConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListTargetAccountConfigurationsIterable.this.client.listTargetAccountConfigurations(ListTargetAccountConfigurationsIterable.this.firstRequest);
            }
            return ListTargetAccountConfigurationsIterable.this.client.listTargetAccountConfigurations((ListTargetAccountConfigurationsRequest)((Object)ListTargetAccountConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

