/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fis.model.ExperimentTargetAccountConfigurationListCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTargetAccountConfigurationSummary;
import software.amazon.awssdk.services.fis.model.FisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperimentTargetAccountConfigurationsResponse
extends FisResponse
implements ToCopyableBuilder<Builder, ListExperimentTargetAccountConfigurationsResponse> {
    private static final SdkField<List<ExperimentTargetAccountConfigurationSummary>> TARGET_ACCOUNT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetAccountConfigurations").getter(ListExperimentTargetAccountConfigurationsResponse.getter(ListExperimentTargetAccountConfigurationsResponse::targetAccountConfigurations)).setter(ListExperimentTargetAccountConfigurationsResponse.setter(Builder::targetAccountConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTargetAccountConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExperimentTargetAccountConfigurationsResponse.getter(ListExperimentTargetAccountConfigurationsResponse::nextToken)).setter(ListExperimentTargetAccountConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ACCOUNT_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExperimentTargetAccountConfigurationSummary> targetAccountConfigurations;
    private final String nextToken;

    private ListExperimentTargetAccountConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.targetAccountConfigurations = builder.targetAccountConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTargetAccountConfigurations() {
        return this.targetAccountConfigurations != null && !(this.targetAccountConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ExperimentTargetAccountConfigurationSummary> targetAccountConfigurations() {
        return this.targetAccountConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetAccountConfigurations() ? this.targetAccountConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentTargetAccountConfigurationsResponse)) {
            return false;
        }
        ListExperimentTargetAccountConfigurationsResponse other = (ListExperimentTargetAccountConfigurationsResponse)((Object)obj);
        return this.hasTargetAccountConfigurations() == other.hasTargetAccountConfigurations() && Objects.equals(this.targetAccountConfigurations(), other.targetAccountConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperimentTargetAccountConfigurationsResponse").add("TargetAccountConfigurations", this.hasTargetAccountConfigurations() ? this.targetAccountConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetAccountConfigurations": {
                return Optional.ofNullable(clazz.cast(this.targetAccountConfigurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentTargetAccountConfigurationsResponse, T> g) {
        return obj -> g.apply((ListExperimentTargetAccountConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisResponse.BuilderImpl
    implements Builder {
        private List<ExperimentTargetAccountConfigurationSummary> targetAccountConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentTargetAccountConfigurationsResponse model) {
            super(model);
            this.targetAccountConfigurations(model.targetAccountConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<ExperimentTargetAccountConfigurationSummary.Builder> getTargetAccountConfigurations() {
            List<ExperimentTargetAccountConfigurationSummary.Builder> result = ExperimentTargetAccountConfigurationListCopier.copyToBuilder(this.targetAccountConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetAccountConfigurations(Collection<ExperimentTargetAccountConfigurationSummary.BuilderImpl> targetAccountConfigurations) {
            this.targetAccountConfigurations = ExperimentTargetAccountConfigurationListCopier.copyFromBuilder(targetAccountConfigurations);
        }

        @Override
        public final Builder targetAccountConfigurations(Collection<ExperimentTargetAccountConfigurationSummary> targetAccountConfigurations) {
            this.targetAccountConfigurations = ExperimentTargetAccountConfigurationListCopier.copy(targetAccountConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountConfigurations(ExperimentTargetAccountConfigurationSummary ... targetAccountConfigurations) {
            this.targetAccountConfigurations(Arrays.asList(targetAccountConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountConfigurations(Consumer<ExperimentTargetAccountConfigurationSummary.Builder> ... targetAccountConfigurations) {
            this.targetAccountConfigurations(Stream.of(targetAccountConfigurations).map(c -> (ExperimentTargetAccountConfigurationSummary)((ExperimentTargetAccountConfigurationSummary.Builder)ExperimentTargetAccountConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExperimentTargetAccountConfigurationsResponse build() {
            return new ListExperimentTargetAccountConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperimentTargetAccountConfigurationsResponse> {
        public Builder targetAccountConfigurations(Collection<ExperimentTargetAccountConfigurationSummary> var1);

        public Builder targetAccountConfigurations(ExperimentTargetAccountConfigurationSummary ... var1);

        public Builder targetAccountConfigurations(Consumer<ExperimentTargetAccountConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

