/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessBufferingHints;
import software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessRetryOptions;
import software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessS3BackupMode;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonOpenSearchServerlessDestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonOpenSearchServerlessDestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::roleARN)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> COLLECTION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionEndpoint").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::collectionEndpoint)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::collectionEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionEndpoint").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::indexName)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<AmazonOpenSearchServerlessBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::bufferingHints)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::bufferingHints)).constructor(AmazonOpenSearchServerlessBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<AmazonOpenSearchServerlessRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::retryOptions)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::retryOptions)).constructor(AmazonOpenSearchServerlessRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::s3BackupModeAsString)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Configuration").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::s3Configuration)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::s3Configuration)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::processingConfiguration)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::cloudWatchLoggingOptions)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(AmazonOpenSearchServerlessDestinationConfiguration.getter(AmazonOpenSearchServerlessDestinationConfiguration::vpcConfiguration)).setter(AmazonOpenSearchServerlessDestinationConfiguration.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, COLLECTION_ENDPOINT_FIELD, INDEX_NAME_FIELD, BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_CONFIGURATION_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, VPC_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmazonOpenSearchServerlessDestinationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String collectionEndpoint;
    private final String indexName;
    private final AmazonOpenSearchServerlessBufferingHints bufferingHints;
    private final AmazonOpenSearchServerlessRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3Configuration;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final VpcConfiguration vpcConfiguration;

    private AmazonOpenSearchServerlessDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.collectionEndpoint = builder.collectionEndpoint;
        this.indexName = builder.indexName;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String collectionEndpoint() {
        return this.collectionEndpoint;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final AmazonOpenSearchServerlessBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final AmazonOpenSearchServerlessRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final AmazonOpenSearchServerlessS3BackupMode s3BackupMode() {
        return AmazonOpenSearchServerlessS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonOpenSearchServerlessDestinationConfiguration)) {
            return false;
        }
        AmazonOpenSearchServerlessDestinationConfiguration other = (AmazonOpenSearchServerlessDestinationConfiguration)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.collectionEndpoint(), other.collectionEndpoint()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonOpenSearchServerlessDestinationConfiguration").add("RoleARN", (Object)this.roleARN()).add("CollectionEndpoint", (Object)this.collectionEndpoint()).add("IndexName", (Object)this.indexName()).add("BufferingHints", (Object)this.bufferingHints()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3Configuration", (Object)this.s3Configuration()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "CollectionEndpoint": {
                return Optional.ofNullable(clazz.cast(this.collectionEndpoint()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("CollectionEndpoint", COLLECTION_ENDPOINT_FIELD);
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        map.put("RetryOptions", RETRY_OPTIONS_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("S3Configuration", S3_CONFIGURATION_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonOpenSearchServerlessDestinationConfiguration, T> g) {
        return obj -> g.apply((AmazonOpenSearchServerlessDestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String collectionEndpoint;
        private String indexName;
        private AmazonOpenSearchServerlessBufferingHints bufferingHints;
        private AmazonOpenSearchServerlessRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationConfiguration s3Configuration;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonOpenSearchServerlessDestinationConfiguration model) {
            this.roleARN(model.roleARN);
            this.collectionEndpoint(model.collectionEndpoint);
            this.indexName(model.indexName);
            this.bufferingHints(model.bufferingHints);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Configuration(model.s3Configuration);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getCollectionEndpoint() {
            return this.collectionEndpoint;
        }

        public final void setCollectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
        }

        @Override
        public final Builder collectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final AmazonOpenSearchServerlessBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(AmazonOpenSearchServerlessBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(AmazonOpenSearchServerlessBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final AmazonOpenSearchServerlessRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(AmazonOpenSearchServerlessRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(AmazonOpenSearchServerlessRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(AmazonOpenSearchServerlessS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public AmazonOpenSearchServerlessDestinationConfiguration build() {
            return new AmazonOpenSearchServerlessDestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonOpenSearchServerlessDestinationConfiguration> {
        public Builder roleARN(String var1);

        public Builder collectionEndpoint(String var1);

        public Builder indexName(String var1);

        public Builder bufferingHints(AmazonOpenSearchServerlessBufferingHints var1);

        default public Builder bufferingHints(Consumer<AmazonOpenSearchServerlessBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((AmazonOpenSearchServerlessBufferingHints)((AmazonOpenSearchServerlessBufferingHints.Builder)AmazonOpenSearchServerlessBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder retryOptions(AmazonOpenSearchServerlessRetryOptions var1);

        default public Builder retryOptions(Consumer<AmazonOpenSearchServerlessRetryOptions.Builder> retryOptions) {
            return this.retryOptions((AmazonOpenSearchServerlessRetryOptions)((AmazonOpenSearchServerlessRetryOptions.Builder)AmazonOpenSearchServerlessRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(AmazonOpenSearchServerlessS3BackupMode var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

