/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.ProcessorParameterName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessorParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessorParameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterName").getter(ProcessorParameter.getter(ProcessorParameter::parameterNameAsString)).setter(ProcessorParameter.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterValue").getter(ProcessorParameter.getter(ProcessorParameter::parameterValue)).setter(ProcessorParameter.setter(Builder::parameterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD, PARAMETER_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProcessorParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String parameterName;
    private final String parameterValue;

    private ProcessorParameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    public final ProcessorParameterName parameterName() {
        return ProcessorParameterName.fromValue(this.parameterName);
    }

    public final String parameterNameAsString() {
        return this.parameterName;
    }

    public final String parameterValue() {
        return this.parameterValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorParameter)) {
            return false;
        }
        ProcessorParameter other = (ProcessorParameter)obj;
        return Objects.equals(this.parameterNameAsString(), other.parameterNameAsString()) && Objects.equals(this.parameterValue(), other.parameterValue());
    }

    public final String toString() {
        return ToString.builder((String)"ProcessorParameter").add("ParameterName", (Object)this.parameterNameAsString()).add("ParameterValue", (Object)this.parameterValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterNameAsString()));
            }
            case "ParameterValue": {
                return Optional.ofNullable(clazz.cast(this.parameterValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ParameterName", PARAMETER_NAME_FIELD);
        map.put("ParameterValue", PARAMETER_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcessorParameter, T> g) {
        return obj -> g.apply((ProcessorParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessorParameter model) {
            this.parameterName(model.parameterName);
            this.parameterValue(model.parameterValue);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        @Override
        public final Builder parameterName(ProcessorParameterName parameterName) {
            this.parameterName(parameterName == null ? null : parameterName.toString());
            return this;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public ProcessorParameter build() {
            return new ProcessorParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessorParameter> {
        public Builder parameterName(String var1);

        public Builder parameterName(ProcessorParameterName var1);

        public Builder parameterValue(String var1);
    }
}

