/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogConfiguration> {
    private static final SdkField<String> CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogARN").getter(CatalogConfiguration.getter(CatalogConfiguration::catalogARN)).setter(CatalogConfiguration.setter(Builder::catalogARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogARN").build()}).build();
    private static final SdkField<String> WAREHOUSE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarehouseLocation").getter(CatalogConfiguration.getter(CatalogConfiguration::warehouseLocation)).setter(CatalogConfiguration.setter(Builder::warehouseLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarehouseLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ARN_FIELD, WAREHOUSE_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CatalogConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogARN;
    private final String warehouseLocation;

    private CatalogConfiguration(BuilderImpl builder) {
        this.catalogARN = builder.catalogARN;
        this.warehouseLocation = builder.warehouseLocation;
    }

    public final String catalogARN() {
        return this.catalogARN;
    }

    public final String warehouseLocation() {
        return this.warehouseLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.warehouseLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogConfiguration)) {
            return false;
        }
        CatalogConfiguration other = (CatalogConfiguration)obj;
        return Objects.equals(this.catalogARN(), other.catalogARN()) && Objects.equals(this.warehouseLocation(), other.warehouseLocation());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogConfiguration").add("CatalogARN", (Object)this.catalogARN()).add("WarehouseLocation", (Object)this.warehouseLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogARN": {
                return Optional.ofNullable(clazz.cast(this.catalogARN()));
            }
            case "WarehouseLocation": {
                return Optional.ofNullable(clazz.cast(this.warehouseLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CatalogARN", CATALOG_ARN_FIELD);
        map.put("WarehouseLocation", WAREHOUSE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogConfiguration, T> g) {
        return obj -> g.apply((CatalogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogARN;
        private String warehouseLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogConfiguration model) {
            this.catalogARN(model.catalogARN);
            this.warehouseLocation(model.warehouseLocation);
        }

        public final String getCatalogARN() {
            return this.catalogARN;
        }

        public final void setCatalogARN(String catalogARN) {
            this.catalogARN = catalogARN;
        }

        @Override
        public final Builder catalogARN(String catalogARN) {
            this.catalogARN = catalogARN;
            return this;
        }

        public final String getWarehouseLocation() {
            return this.warehouseLocation;
        }

        public final void setWarehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
        }

        @Override
        public final Builder warehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
            return this;
        }

        public CatalogConfiguration build() {
            return new CatalogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogConfiguration> {
        public Builder catalogARN(String var1);

        public Builder warehouseLocation(String var1);
    }
}

