/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamType;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeliveryStreamsRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, ListDeliveryStreamsRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListDeliveryStreamsRequest.getter(ListDeliveryStreamsRequest::limit)).setter(ListDeliveryStreamsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStreamType").getter(ListDeliveryStreamsRequest.getter(ListDeliveryStreamsRequest::deliveryStreamTypeAsString)).setter(ListDeliveryStreamsRequest.setter(Builder::deliveryStreamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamType").build()}).build();
    private static final SdkField<String> EXCLUSIVE_START_DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusiveStartDeliveryStreamName").getter(ListDeliveryStreamsRequest.getter(ListDeliveryStreamsRequest::exclusiveStartDeliveryStreamName)).setter(ListDeliveryStreamsRequest.setter(Builder::exclusiveStartDeliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartDeliveryStreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, DELIVERY_STREAM_TYPE_FIELD, EXCLUSIVE_START_DELIVERY_STREAM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDeliveryStreamsRequest.memberNameToFieldInitializer();
    private final Integer limit;
    private final String deliveryStreamType;
    private final String exclusiveStartDeliveryStreamName;

    private ListDeliveryStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.exclusiveStartDeliveryStreamName = builder.exclusiveStartDeliveryStreamName;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(this.deliveryStreamType);
    }

    public final String deliveryStreamTypeAsString() {
        return this.deliveryStreamType;
    }

    public final String exclusiveStartDeliveryStreamName() {
        return this.exclusiveStartDeliveryStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartDeliveryStreamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsRequest)) {
            return false;
        }
        ListDeliveryStreamsRequest other = (ListDeliveryStreamsRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.deliveryStreamTypeAsString(), other.deliveryStreamTypeAsString()) && Objects.equals(this.exclusiveStartDeliveryStreamName(), other.exclusiveStartDeliveryStreamName());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeliveryStreamsRequest").add("Limit", (Object)this.limit()).add("DeliveryStreamType", (Object)this.deliveryStreamTypeAsString()).add("ExclusiveStartDeliveryStreamName", (Object)this.exclusiveStartDeliveryStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "DeliveryStreamType": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamTypeAsString()));
            }
            case "ExclusiveStartDeliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartDeliveryStreamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Limit", LIMIT_FIELD);
        map.put("DeliveryStreamType", DELIVERY_STREAM_TYPE_FIELD);
        map.put("ExclusiveStartDeliveryStreamName", EXCLUSIVE_START_DELIVERY_STREAM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeliveryStreamsRequest, T> g) {
        return obj -> g.apply((ListDeliveryStreamsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private Integer limit;
        private String deliveryStreamType;
        private String exclusiveStartDeliveryStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsRequest model) {
            super(model);
            this.limit(model.limit);
            this.deliveryStreamType(model.deliveryStreamType);
            this.exclusiveStartDeliveryStreamName(model.exclusiveStartDeliveryStreamName);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getDeliveryStreamType() {
            return this.deliveryStreamType;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType == null ? null : deliveryStreamType.toString());
            return this;
        }

        public final String getExclusiveStartDeliveryStreamName() {
            return this.exclusiveStartDeliveryStreamName;
        }

        public final void setExclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
        }

        @Override
        public final Builder exclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeliveryStreamsRequest build() {
            return new ListDeliveryStreamsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeliveryStreamsRequest> {
        public Builder limit(Integer var1);

        public Builder deliveryStreamType(String var1);

        public Builder deliveryStreamType(DeliveryStreamType var1);

        public Builder exclusiveStartDeliveryStreamName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

