/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceBufferingHints;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceIndexRotationPeriod;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceRetryOptions;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.DocumentIdOptions;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonopensearchserviceDestinationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonopensearchserviceDestinationUpdate> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::roleARN)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainARN").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::domainARN)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::domainARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainARN").build()}).build();
    private static final SdkField<String> CLUSTER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterEndpoint").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::clusterEndpoint)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::clusterEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoint").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::indexName)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::typeName)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> INDEX_ROTATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexRotationPeriod").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::indexRotationPeriodAsString)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::indexRotationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexRotationPeriod").build()}).build();
    private static final SdkField<AmazonopensearchserviceBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::bufferingHints)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::bufferingHints)).constructor(AmazonopensearchserviceBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<AmazonopensearchserviceRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::retryOptions)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::retryOptions)).constructor(AmazonopensearchserviceRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<S3DestinationUpdate> S3_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Update").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::s3Update)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::s3Update)).constructor(S3DestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Update").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::processingConfiguration)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::cloudWatchLoggingOptions)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<DocumentIdOptions> DOCUMENT_ID_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentIdOptions").getter(AmazonopensearchserviceDestinationUpdate.getter(AmazonopensearchserviceDestinationUpdate::documentIdOptions)).setter(AmazonopensearchserviceDestinationUpdate.setter(Builder::documentIdOptions)).constructor(DocumentIdOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIdOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DOMAIN_ARN_FIELD, CLUSTER_ENDPOINT_FIELD, INDEX_NAME_FIELD, TYPE_NAME_FIELD, INDEX_ROTATION_PERIOD_FIELD, BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_UPDATE_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, DOCUMENT_ID_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String domainARN;
    private final String clusterEndpoint;
    private final String indexName;
    private final String typeName;
    private final String indexRotationPeriod;
    private final AmazonopensearchserviceBufferingHints bufferingHints;
    private final AmazonopensearchserviceRetryOptions retryOptions;
    private final S3DestinationUpdate s3Update;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final DocumentIdOptions documentIdOptions;

    private AmazonopensearchserviceDestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3Update = builder.s3Update;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.documentIdOptions = builder.documentIdOptions;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String domainARN() {
        return this.domainARN;
    }

    public final String clusterEndpoint() {
        return this.clusterEndpoint;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final AmazonopensearchserviceIndexRotationPeriod indexRotationPeriod() {
        return AmazonopensearchserviceIndexRotationPeriod.fromValue(this.indexRotationPeriod);
    }

    public final String indexRotationPeriodAsString() {
        return this.indexRotationPeriod;
    }

    public final AmazonopensearchserviceBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final AmazonopensearchserviceRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final S3DestinationUpdate s3Update() {
        return this.s3Update;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final DocumentIdOptions documentIdOptions() {
        return this.documentIdOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexRotationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonopensearchserviceDestinationUpdate)) {
            return false;
        }
        AmazonopensearchserviceDestinationUpdate other = (AmazonopensearchserviceDestinationUpdate)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.domainARN(), other.domainARN()) && Objects.equals(this.clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.indexRotationPeriodAsString(), other.indexRotationPeriodAsString()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3Update(), other.s3Update()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.documentIdOptions(), other.documentIdOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonopensearchserviceDestinationUpdate").add("RoleARN", (Object)this.roleARN()).add("DomainARN", (Object)this.domainARN()).add("ClusterEndpoint", (Object)this.clusterEndpoint()).add("IndexName", (Object)this.indexName()).add("TypeName", (Object)this.typeName()).add("IndexRotationPeriod", (Object)this.indexRotationPeriodAsString()).add("BufferingHints", (Object)this.bufferingHints()).add("RetryOptions", (Object)this.retryOptions()).add("S3Update", (Object)this.s3Update()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("DocumentIdOptions", (Object)this.documentIdOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "DomainARN": {
                return Optional.ofNullable(clazz.cast(this.domainARN()));
            }
            case "ClusterEndpoint": {
                return Optional.ofNullable(clazz.cast(this.clusterEndpoint()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "IndexRotationPeriod": {
                return Optional.ofNullable(clazz.cast(this.indexRotationPeriodAsString()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3Update": {
                return Optional.ofNullable(clazz.cast(this.s3Update()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "DocumentIdOptions": {
                return Optional.ofNullable(clazz.cast(this.documentIdOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonopensearchserviceDestinationUpdate, T> g) {
        return obj -> g.apply((AmazonopensearchserviceDestinationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String domainARN;
        private String clusterEndpoint;
        private String indexName;
        private String typeName;
        private String indexRotationPeriod;
        private AmazonopensearchserviceBufferingHints bufferingHints;
        private AmazonopensearchserviceRetryOptions retryOptions;
        private S3DestinationUpdate s3Update;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private DocumentIdOptions documentIdOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonopensearchserviceDestinationUpdate model) {
            this.roleARN(model.roleARN);
            this.domainARN(model.domainARN);
            this.clusterEndpoint(model.clusterEndpoint);
            this.indexName(model.indexName);
            this.typeName(model.typeName);
            this.indexRotationPeriod(model.indexRotationPeriod);
            this.bufferingHints(model.bufferingHints);
            this.retryOptions(model.retryOptions);
            this.s3Update(model.s3Update);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.documentIdOptions(model.documentIdOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getDomainARN() {
            return this.domainARN;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final String getClusterEndpoint() {
            return this.clusterEndpoint;
        }

        public final void setClusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
        }

        @Override
        public final Builder clusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getIndexRotationPeriod() {
            return this.indexRotationPeriod;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(AmazonopensearchserviceIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod == null ? null : indexRotationPeriod.toString());
            return this;
        }

        public final AmazonopensearchserviceBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(AmazonopensearchserviceBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(AmazonopensearchserviceBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final AmazonopensearchserviceRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(AmazonopensearchserviceRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(AmazonopensearchserviceRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return this.s3Update != null ? this.s3Update.toBuilder() : null;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final DocumentIdOptions.Builder getDocumentIdOptions() {
            return this.documentIdOptions != null ? this.documentIdOptions.toBuilder() : null;
        }

        public final void setDocumentIdOptions(DocumentIdOptions.BuilderImpl documentIdOptions) {
            this.documentIdOptions = documentIdOptions != null ? documentIdOptions.build() : null;
        }

        @Override
        public final Builder documentIdOptions(DocumentIdOptions documentIdOptions) {
            this.documentIdOptions = documentIdOptions;
            return this;
        }

        public AmazonopensearchserviceDestinationUpdate build() {
            return new AmazonopensearchserviceDestinationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonopensearchserviceDestinationUpdate> {
        public Builder roleARN(String var1);

        public Builder domainARN(String var1);

        public Builder clusterEndpoint(String var1);

        public Builder indexName(String var1);

        public Builder typeName(String var1);

        public Builder indexRotationPeriod(String var1);

        public Builder indexRotationPeriod(AmazonopensearchserviceIndexRotationPeriod var1);

        public Builder bufferingHints(AmazonopensearchserviceBufferingHints var1);

        default public Builder bufferingHints(Consumer<AmazonopensearchserviceBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((AmazonopensearchserviceBufferingHints)((AmazonopensearchserviceBufferingHints.Builder)AmazonopensearchserviceBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder retryOptions(AmazonopensearchserviceRetryOptions var1);

        default public Builder retryOptions(Consumer<AmazonopensearchserviceRetryOptions.Builder> retryOptions) {
            return this.retryOptions((AmazonopensearchserviceRetryOptions)((AmazonopensearchserviceRetryOptions.Builder)AmazonopensearchserviceRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3Update(S3DestinationUpdate var1);

        default public Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return this.s3Update((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().applyMutation(s3Update)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder documentIdOptions(DocumentIdOptions var1);

        default public Builder documentIdOptions(Consumer<DocumentIdOptions.Builder> documentIdOptions) {
            return this.documentIdOptions((DocumentIdOptions)((DocumentIdOptions.Builder)DocumentIdOptions.builder().applyMutation(documentIdOptions)).build());
        }
    }
}

