/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDestinationRequest extends FirehoseRequest implements
        ToCopyableBuilder<UpdateDestinationRequest.Builder, UpdateDestinationRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamName").getter(getter(UpdateDestinationRequest::deliveryStreamName))
            .setter(setter(Builder::deliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build())
            .build();

    private static final SdkField<String> CURRENT_DELIVERY_STREAM_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentDeliveryStreamVersionId")
            .getter(getter(UpdateDestinationRequest::currentDeliveryStreamVersionId))
            .setter(setter(Builder::currentDeliveryStreamVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentDeliveryStreamVersionId")
                    .build()).build();

    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationId").getter(getter(UpdateDestinationRequest::destinationId))
            .setter(setter(Builder::destinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationId").build()).build();

    private static final SdkField<S3DestinationUpdate> S3_DESTINATION_UPDATE_FIELD = SdkField
            .<S3DestinationUpdate> builder(MarshallingType.SDK_POJO).memberName("S3DestinationUpdate")
            .getter(getter(UpdateDestinationRequest::s3DestinationUpdate)).setter(setter(Builder::s3DestinationUpdate))
            .constructor(S3DestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationUpdate").build())
            .build();

    private static final SdkField<ExtendedS3DestinationUpdate> EXTENDED_S3_DESTINATION_UPDATE_FIELD = SdkField
            .<ExtendedS3DestinationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ExtendedS3DestinationUpdate")
            .getter(getter(UpdateDestinationRequest::extendedS3DestinationUpdate))
            .setter(setter(Builder::extendedS3DestinationUpdate))
            .constructor(ExtendedS3DestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedS3DestinationUpdate")
                    .build()).build();

    private static final SdkField<RedshiftDestinationUpdate> REDSHIFT_DESTINATION_UPDATE_FIELD = SdkField
            .<RedshiftDestinationUpdate> builder(MarshallingType.SDK_POJO).memberName("RedshiftDestinationUpdate")
            .getter(getter(UpdateDestinationRequest::redshiftDestinationUpdate))
            .setter(setter(Builder::redshiftDestinationUpdate)).constructor(RedshiftDestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDestinationUpdate").build())
            .build();

    private static final SdkField<ElasticsearchDestinationUpdate> ELASTICSEARCH_DESTINATION_UPDATE_FIELD = SdkField
            .<ElasticsearchDestinationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ElasticsearchDestinationUpdate")
            .getter(getter(UpdateDestinationRequest::elasticsearchDestinationUpdate))
            .setter(setter(Builder::elasticsearchDestinationUpdate))
            .constructor(ElasticsearchDestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchDestinationUpdate")
                    .build()).build();

    private static final SdkField<AmazonopensearchserviceDestinationUpdate> AMAZONOPENSEARCHSERVICE_DESTINATION_UPDATE_FIELD = SdkField
            .<AmazonopensearchserviceDestinationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonopensearchserviceDestinationUpdate")
            .getter(getter(UpdateDestinationRequest::amazonopensearchserviceDestinationUpdate))
            .setter(setter(Builder::amazonopensearchserviceDestinationUpdate))
            .constructor(AmazonopensearchserviceDestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AmazonopensearchserviceDestinationUpdate").build()).build();

    private static final SdkField<SplunkDestinationUpdate> SPLUNK_DESTINATION_UPDATE_FIELD = SdkField
            .<SplunkDestinationUpdate> builder(MarshallingType.SDK_POJO).memberName("SplunkDestinationUpdate")
            .getter(getter(UpdateDestinationRequest::splunkDestinationUpdate)).setter(setter(Builder::splunkDestinationUpdate))
            .constructor(SplunkDestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplunkDestinationUpdate").build())
            .build();

    private static final SdkField<HttpEndpointDestinationUpdate> HTTP_ENDPOINT_DESTINATION_UPDATE_FIELD = SdkField
            .<HttpEndpointDestinationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("HttpEndpointDestinationUpdate")
            .getter(getter(UpdateDestinationRequest::httpEndpointDestinationUpdate))
            .setter(setter(Builder::httpEndpointDestinationUpdate))
            .constructor(HttpEndpointDestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointDestinationUpdate")
                    .build()).build();

    private static final SdkField<AmazonOpenSearchServerlessDestinationUpdate> AMAZON_OPEN_SEARCH_SERVERLESS_DESTINATION_UPDATE_FIELD = SdkField
            .<AmazonOpenSearchServerlessDestinationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonOpenSearchServerlessDestinationUpdate")
            .getter(getter(UpdateDestinationRequest::amazonOpenSearchServerlessDestinationUpdate))
            .setter(setter(Builder::amazonOpenSearchServerlessDestinationUpdate))
            .constructor(AmazonOpenSearchServerlessDestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AmazonOpenSearchServerlessDestinationUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD,
            CURRENT_DELIVERY_STREAM_VERSION_ID_FIELD, DESTINATION_ID_FIELD, S3_DESTINATION_UPDATE_FIELD,
            EXTENDED_S3_DESTINATION_UPDATE_FIELD, REDSHIFT_DESTINATION_UPDATE_FIELD, ELASTICSEARCH_DESTINATION_UPDATE_FIELD,
            AMAZONOPENSEARCHSERVICE_DESTINATION_UPDATE_FIELD, SPLUNK_DESTINATION_UPDATE_FIELD,
            HTTP_ENDPOINT_DESTINATION_UPDATE_FIELD, AMAZON_OPEN_SEARCH_SERVERLESS_DESTINATION_UPDATE_FIELD));

    private final String deliveryStreamName;

    private final String currentDeliveryStreamVersionId;

    private final String destinationId;

    private final S3DestinationUpdate s3DestinationUpdate;

    private final ExtendedS3DestinationUpdate extendedS3DestinationUpdate;

    private final RedshiftDestinationUpdate redshiftDestinationUpdate;

    private final ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;

    private final AmazonopensearchserviceDestinationUpdate amazonopensearchserviceDestinationUpdate;

    private final SplunkDestinationUpdate splunkDestinationUpdate;

    private final HttpEndpointDestinationUpdate httpEndpointDestinationUpdate;

    private final AmazonOpenSearchServerlessDestinationUpdate amazonOpenSearchServerlessDestinationUpdate;

    private UpdateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.currentDeliveryStreamVersionId = builder.currentDeliveryStreamVersionId;
        this.destinationId = builder.destinationId;
        this.s3DestinationUpdate = builder.s3DestinationUpdate;
        this.extendedS3DestinationUpdate = builder.extendedS3DestinationUpdate;
        this.redshiftDestinationUpdate = builder.redshiftDestinationUpdate;
        this.elasticsearchDestinationUpdate = builder.elasticsearchDestinationUpdate;
        this.amazonopensearchserviceDestinationUpdate = builder.amazonopensearchserviceDestinationUpdate;
        this.splunkDestinationUpdate = builder.splunkDestinationUpdate;
        this.httpEndpointDestinationUpdate = builder.httpEndpointDestinationUpdate;
        this.amazonOpenSearchServerlessDestinationUpdate = builder.amazonOpenSearchServerlessDestinationUpdate;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public final String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * Obtain this value from the <code>VersionId</code> result of <a>DeliveryStreamDescription</a>. This value is
     * required, and helps the service perform conditional operations. For example, if there is an interleaving update
     * and this value is null, then the update destination fails. After the update is successful, the
     * <code>VersionId</code> value is updated. The service then performs a merge of the old configuration with the new
     * configuration.
     * </p>
     * 
     * @return Obtain this value from the <code>VersionId</code> result of <a>DeliveryStreamDescription</a>. This value
     *         is required, and helps the service perform conditional operations. For example, if there is an
     *         interleaving update and this value is null, then the update destination fails. After the update is
     *         successful, the <code>VersionId</code> value is updated. The service then performs a merge of the old
     *         configuration with the new configuration.
     */
    public final String currentDeliveryStreamVersionId() {
        return currentDeliveryStreamVersionId;
    }

    /**
     * <p>
     * The ID of the destination.
     * </p>
     * 
     * @return The ID of the destination.
     */
    public final String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * [Deprecated] Describes an update for a destination in Amazon S3.
     * </p>
     * 
     * @return [Deprecated] Describes an update for a destination in Amazon S3.
     * @deprecated
     */
    @Deprecated
    public final S3DestinationUpdate s3DestinationUpdate() {
        return s3DestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon S3.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon S3.
     */
    public final ExtendedS3DestinationUpdate extendedS3DestinationUpdate() {
        return extendedS3DestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon Redshift.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon Redshift.
     */
    public final RedshiftDestinationUpdate redshiftDestinationUpdate() {
        return redshiftDestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon ES.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon ES.
     */
    public final ElasticsearchDestinationUpdate elasticsearchDestinationUpdate() {
        return elasticsearchDestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon OpenSearch Service.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon OpenSearch Service.
     */
    public final AmazonopensearchserviceDestinationUpdate amazonopensearchserviceDestinationUpdate() {
        return amazonopensearchserviceDestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Splunk.
     * </p>
     * 
     * @return Describes an update for a destination in Splunk.
     */
    public final SplunkDestinationUpdate splunkDestinationUpdate() {
        return splunkDestinationUpdate;
    }

    /**
     * <p>
     * Describes an update to the specified HTTP endpoint destination.
     * </p>
     * 
     * @return Describes an update to the specified HTTP endpoint destination.
     */
    public final HttpEndpointDestinationUpdate httpEndpointDestinationUpdate() {
        return httpEndpointDestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in the Serverless offering for Amazon OpenSearch Service.
     * </p>
     * 
     * @return Describes an update for a destination in the Serverless offering for Amazon OpenSearch Service.
     */
    public final AmazonOpenSearchServerlessDestinationUpdate amazonOpenSearchServerlessDestinationUpdate() {
        return amazonOpenSearchServerlessDestinationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(currentDeliveryStreamVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(extendedS3DestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(amazonopensearchserviceDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(splunkDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpointDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(amazonOpenSearchServerlessDestinationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName())
                && Objects.equals(currentDeliveryStreamVersionId(), other.currentDeliveryStreamVersionId())
                && Objects.equals(destinationId(), other.destinationId())
                && Objects.equals(s3DestinationUpdate(), other.s3DestinationUpdate())
                && Objects.equals(extendedS3DestinationUpdate(), other.extendedS3DestinationUpdate())
                && Objects.equals(redshiftDestinationUpdate(), other.redshiftDestinationUpdate())
                && Objects.equals(elasticsearchDestinationUpdate(), other.elasticsearchDestinationUpdate())
                && Objects.equals(amazonopensearchserviceDestinationUpdate(), other.amazonopensearchserviceDestinationUpdate())
                && Objects.equals(splunkDestinationUpdate(), other.splunkDestinationUpdate())
                && Objects.equals(httpEndpointDestinationUpdate(), other.httpEndpointDestinationUpdate())
                && Objects.equals(amazonOpenSearchServerlessDestinationUpdate(),
                        other.amazonOpenSearchServerlessDestinationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDestinationRequest").add("DeliveryStreamName", deliveryStreamName())
                .add("CurrentDeliveryStreamVersionId", currentDeliveryStreamVersionId()).add("DestinationId", destinationId())
                .add("S3DestinationUpdate", s3DestinationUpdate())
                .add("ExtendedS3DestinationUpdate", extendedS3DestinationUpdate())
                .add("RedshiftDestinationUpdate", redshiftDestinationUpdate())
                .add("ElasticsearchDestinationUpdate", elasticsearchDestinationUpdate())
                .add("AmazonopensearchserviceDestinationUpdate", amazonopensearchserviceDestinationUpdate())
                .add("SplunkDestinationUpdate", splunkDestinationUpdate())
                .add("HttpEndpointDestinationUpdate", httpEndpointDestinationUpdate())
                .add("AmazonOpenSearchServerlessDestinationUpdate", amazonOpenSearchServerlessDestinationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.ofNullable(clazz.cast(deliveryStreamName()));
        case "CurrentDeliveryStreamVersionId":
            return Optional.ofNullable(clazz.cast(currentDeliveryStreamVersionId()));
        case "DestinationId":
            return Optional.ofNullable(clazz.cast(destinationId()));
        case "S3DestinationUpdate":
            return Optional.ofNullable(clazz.cast(s3DestinationUpdate()));
        case "ExtendedS3DestinationUpdate":
            return Optional.ofNullable(clazz.cast(extendedS3DestinationUpdate()));
        case "RedshiftDestinationUpdate":
            return Optional.ofNullable(clazz.cast(redshiftDestinationUpdate()));
        case "ElasticsearchDestinationUpdate":
            return Optional.ofNullable(clazz.cast(elasticsearchDestinationUpdate()));
        case "AmazonopensearchserviceDestinationUpdate":
            return Optional.ofNullable(clazz.cast(amazonopensearchserviceDestinationUpdate()));
        case "SplunkDestinationUpdate":
            return Optional.ofNullable(clazz.cast(splunkDestinationUpdate()));
        case "HttpEndpointDestinationUpdate":
            return Optional.ofNullable(clazz.cast(httpEndpointDestinationUpdate()));
        case "AmazonOpenSearchServerlessDestinationUpdate":
            return Optional.ofNullable(clazz.cast(amazonOpenSearchServerlessDestinationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDestinationRequest, T> g) {
        return obj -> g.apply((UpdateDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDestinationRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * Obtain this value from the <code>VersionId</code> result of <a>DeliveryStreamDescription</a>. This value is
         * required, and helps the service perform conditional operations. For example, if there is an interleaving
         * update and this value is null, then the update destination fails. After the update is successful, the
         * <code>VersionId</code> value is updated. The service then performs a merge of the old configuration with the
         * new configuration.
         * </p>
         * 
         * @param currentDeliveryStreamVersionId
         *        Obtain this value from the <code>VersionId</code> result of <a>DeliveryStreamDescription</a>. This
         *        value is required, and helps the service perform conditional operations. For example, if there is an
         *        interleaving update and this value is null, then the update destination fails. After the update is
         *        successful, the <code>VersionId</code> value is updated. The service then performs a merge of the old
         *        configuration with the new configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentDeliveryStreamVersionId(String currentDeliveryStreamVersionId);

        /**
         * <p>
         * The ID of the destination.
         * </p>
         * 
         * @param destinationId
         *        The ID of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * [Deprecated] Describes an update for a destination in Amazon S3.
         * </p>
         * 
         * @param s3DestinationUpdate
         *        [Deprecated] Describes an update for a destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder s3DestinationUpdate(S3DestinationUpdate s3DestinationUpdate);

        /**
         * <p>
         * [Deprecated] Describes an update for a destination in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DestinationUpdate.Builder} avoiding the
         * need to create one manually via {@link S3DestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #s3DestinationUpdate(S3DestinationUpdate)}.
         * 
         * @param s3DestinationUpdate
         *        a consumer that will call methods on {@link S3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationUpdate(S3DestinationUpdate)
         * @deprecated
         */
        @Deprecated
        default Builder s3DestinationUpdate(Consumer<S3DestinationUpdate.Builder> s3DestinationUpdate) {
            return s3DestinationUpdate(S3DestinationUpdate.builder().applyMutation(s3DestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update for a destination in Amazon S3.
         * </p>
         * 
         * @param extendedS3DestinationUpdate
         *        Describes an update for a destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate extendedS3DestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExtendedS3DestinationUpdate.Builder}
         * avoiding the need to create one manually via {@link ExtendedS3DestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExtendedS3DestinationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #extendedS3DestinationUpdate(ExtendedS3DestinationUpdate)}.
         * 
         * @param extendedS3DestinationUpdate
         *        a consumer that will call methods on {@link ExtendedS3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extendedS3DestinationUpdate(ExtendedS3DestinationUpdate)
         */
        default Builder extendedS3DestinationUpdate(Consumer<ExtendedS3DestinationUpdate.Builder> extendedS3DestinationUpdate) {
            return extendedS3DestinationUpdate(ExtendedS3DestinationUpdate.builder().applyMutation(extendedS3DestinationUpdate)
                    .build());
        }

        /**
         * <p>
         * Describes an update for a destination in Amazon Redshift.
         * </p>
         * 
         * @param redshiftDestinationUpdate
         *        Describes an update for a destination in Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDestinationUpdate(RedshiftDestinationUpdate redshiftDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon Redshift.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftDestinationUpdate.Builder}
         * avoiding the need to create one manually via {@link RedshiftDestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftDestinationUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftDestinationUpdate(RedshiftDestinationUpdate)}.
         * 
         * @param redshiftDestinationUpdate
         *        a consumer that will call methods on {@link RedshiftDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDestinationUpdate(RedshiftDestinationUpdate)
         */
        default Builder redshiftDestinationUpdate(Consumer<RedshiftDestinationUpdate.Builder> redshiftDestinationUpdate) {
            return redshiftDestinationUpdate(RedshiftDestinationUpdate.builder().applyMutation(redshiftDestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update for a destination in Amazon ES.
         * </p>
         * 
         * @param elasticsearchDestinationUpdate
         *        Describes an update for a destination in Amazon ES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon ES.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticsearchDestinationUpdate.Builder}
         * avoiding the need to create one manually via {@link ElasticsearchDestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticsearchDestinationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate)}.
         * 
         * @param elasticsearchDestinationUpdate
         *        a consumer that will call methods on {@link ElasticsearchDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate)
         */
        default Builder elasticsearchDestinationUpdate(
                Consumer<ElasticsearchDestinationUpdate.Builder> elasticsearchDestinationUpdate) {
            return elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate.builder()
                    .applyMutation(elasticsearchDestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update for a destination in Amazon OpenSearch Service.
         * </p>
         * 
         * @param amazonopensearchserviceDestinationUpdate
         *        Describes an update for a destination in Amazon OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonopensearchserviceDestinationUpdate(
                AmazonopensearchserviceDestinationUpdate amazonopensearchserviceDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon OpenSearch Service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonopensearchserviceDestinationUpdate.Builder} avoiding the need to create one manually via
         * {@link AmazonopensearchserviceDestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonopensearchserviceDestinationUpdate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #amazonopensearchserviceDestinationUpdate(AmazonopensearchserviceDestinationUpdate)}.
         * 
         * @param amazonopensearchserviceDestinationUpdate
         *        a consumer that will call methods on {@link AmazonopensearchserviceDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonopensearchserviceDestinationUpdate(AmazonopensearchserviceDestinationUpdate)
         */
        default Builder amazonopensearchserviceDestinationUpdate(
                Consumer<AmazonopensearchserviceDestinationUpdate.Builder> amazonopensearchserviceDestinationUpdate) {
            return amazonopensearchserviceDestinationUpdate(AmazonopensearchserviceDestinationUpdate.builder()
                    .applyMutation(amazonopensearchserviceDestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update for a destination in Splunk.
         * </p>
         * 
         * @param splunkDestinationUpdate
         *        Describes an update for a destination in Splunk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splunkDestinationUpdate(SplunkDestinationUpdate splunkDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Splunk.
         * </p>
         * This is a convenience method that creates an instance of the {@link SplunkDestinationUpdate.Builder} avoiding
         * the need to create one manually via {@link SplunkDestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SplunkDestinationUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #splunkDestinationUpdate(SplunkDestinationUpdate)}.
         * 
         * @param splunkDestinationUpdate
         *        a consumer that will call methods on {@link SplunkDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splunkDestinationUpdate(SplunkDestinationUpdate)
         */
        default Builder splunkDestinationUpdate(Consumer<SplunkDestinationUpdate.Builder> splunkDestinationUpdate) {
            return splunkDestinationUpdate(SplunkDestinationUpdate.builder().applyMutation(splunkDestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update to the specified HTTP endpoint destination.
         * </p>
         * 
         * @param httpEndpointDestinationUpdate
         *        Describes an update to the specified HTTP endpoint destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpEndpointDestinationUpdate(HttpEndpointDestinationUpdate httpEndpointDestinationUpdate);

        /**
         * <p>
         * Describes an update to the specified HTTP endpoint destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpEndpointDestinationUpdate.Builder}
         * avoiding the need to create one manually via {@link HttpEndpointDestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpEndpointDestinationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #httpEndpointDestinationUpdate(HttpEndpointDestinationUpdate)}.
         * 
         * @param httpEndpointDestinationUpdate
         *        a consumer that will call methods on {@link HttpEndpointDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpEndpointDestinationUpdate(HttpEndpointDestinationUpdate)
         */
        default Builder httpEndpointDestinationUpdate(
                Consumer<HttpEndpointDestinationUpdate.Builder> httpEndpointDestinationUpdate) {
            return httpEndpointDestinationUpdate(HttpEndpointDestinationUpdate.builder()
                    .applyMutation(httpEndpointDestinationUpdate).build());
        }

        /**
         * <p>
         * Describes an update for a destination in the Serverless offering for Amazon OpenSearch Service.
         * </p>
         * 
         * @param amazonOpenSearchServerlessDestinationUpdate
         *        Describes an update for a destination in the Serverless offering for Amazon OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonOpenSearchServerlessDestinationUpdate(
                AmazonOpenSearchServerlessDestinationUpdate amazonOpenSearchServerlessDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in the Serverless offering for Amazon OpenSearch Service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonOpenSearchServerlessDestinationUpdate.Builder} avoiding the need to create one manually via
         * {@link AmazonOpenSearchServerlessDestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonOpenSearchServerlessDestinationUpdate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #amazonOpenSearchServerlessDestinationUpdate(AmazonOpenSearchServerlessDestinationUpdate)}.
         * 
         * @param amazonOpenSearchServerlessDestinationUpdate
         *        a consumer that will call methods on {@link AmazonOpenSearchServerlessDestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonOpenSearchServerlessDestinationUpdate(AmazonOpenSearchServerlessDestinationUpdate)
         */
        default Builder amazonOpenSearchServerlessDestinationUpdate(
                Consumer<AmazonOpenSearchServerlessDestinationUpdate.Builder> amazonOpenSearchServerlessDestinationUpdate) {
            return amazonOpenSearchServerlessDestinationUpdate(AmazonOpenSearchServerlessDestinationUpdate.builder()
                    .applyMutation(amazonOpenSearchServerlessDestinationUpdate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private String currentDeliveryStreamVersionId;

        private String destinationId;

        private S3DestinationUpdate s3DestinationUpdate;

        private ExtendedS3DestinationUpdate extendedS3DestinationUpdate;

        private RedshiftDestinationUpdate redshiftDestinationUpdate;

        private ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;

        private AmazonopensearchserviceDestinationUpdate amazonopensearchserviceDestinationUpdate;

        private SplunkDestinationUpdate splunkDestinationUpdate;

        private HttpEndpointDestinationUpdate httpEndpointDestinationUpdate;

        private AmazonOpenSearchServerlessDestinationUpdate amazonOpenSearchServerlessDestinationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            super(model);
            deliveryStreamName(model.deliveryStreamName);
            currentDeliveryStreamVersionId(model.currentDeliveryStreamVersionId);
            destinationId(model.destinationId);
            s3DestinationUpdate(model.s3DestinationUpdate);
            extendedS3DestinationUpdate(model.extendedS3DestinationUpdate);
            redshiftDestinationUpdate(model.redshiftDestinationUpdate);
            elasticsearchDestinationUpdate(model.elasticsearchDestinationUpdate);
            amazonopensearchserviceDestinationUpdate(model.amazonopensearchserviceDestinationUpdate);
            splunkDestinationUpdate(model.splunkDestinationUpdate);
            httpEndpointDestinationUpdate(model.httpEndpointDestinationUpdate);
            amazonOpenSearchServerlessDestinationUpdate(model.amazonOpenSearchServerlessDestinationUpdate);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final String getCurrentDeliveryStreamVersionId() {
            return currentDeliveryStreamVersionId;
        }

        public final void setCurrentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
        }

        @Override
        public final Builder currentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
            return this;
        }

        public final String getDestinationId() {
            return destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        @Deprecated
        public final S3DestinationUpdate.Builder getS3DestinationUpdate() {
            return s3DestinationUpdate != null ? s3DestinationUpdate.toBuilder() : null;
        }

        @Deprecated
        public final void setS3DestinationUpdate(S3DestinationUpdate.BuilderImpl s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate != null ? s3DestinationUpdate.build() : null;
        }

        @Override
        @Deprecated
        public final Builder s3DestinationUpdate(S3DestinationUpdate s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate;
            return this;
        }

        public final ExtendedS3DestinationUpdate.Builder getExtendedS3DestinationUpdate() {
            return extendedS3DestinationUpdate != null ? extendedS3DestinationUpdate.toBuilder() : null;
        }

        public final void setExtendedS3DestinationUpdate(ExtendedS3DestinationUpdate.BuilderImpl extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate != null ? extendedS3DestinationUpdate.build() : null;
        }

        @Override
        public final Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate;
            return this;
        }

        public final RedshiftDestinationUpdate.Builder getRedshiftDestinationUpdate() {
            return redshiftDestinationUpdate != null ? redshiftDestinationUpdate.toBuilder() : null;
        }

        public final void setRedshiftDestinationUpdate(RedshiftDestinationUpdate.BuilderImpl redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate != null ? redshiftDestinationUpdate.build() : null;
        }

        @Override
        public final Builder redshiftDestinationUpdate(RedshiftDestinationUpdate redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate;
            return this;
        }

        public final ElasticsearchDestinationUpdate.Builder getElasticsearchDestinationUpdate() {
            return elasticsearchDestinationUpdate != null ? elasticsearchDestinationUpdate.toBuilder() : null;
        }

        public final void setElasticsearchDestinationUpdate(
                ElasticsearchDestinationUpdate.BuilderImpl elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate != null ? elasticsearchDestinationUpdate.build()
                    : null;
        }

        @Override
        public final Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate;
            return this;
        }

        public final AmazonopensearchserviceDestinationUpdate.Builder getAmazonopensearchserviceDestinationUpdate() {
            return amazonopensearchserviceDestinationUpdate != null ? amazonopensearchserviceDestinationUpdate.toBuilder() : null;
        }

        public final void setAmazonopensearchserviceDestinationUpdate(
                AmazonopensearchserviceDestinationUpdate.BuilderImpl amazonopensearchserviceDestinationUpdate) {
            this.amazonopensearchserviceDestinationUpdate = amazonopensearchserviceDestinationUpdate != null ? amazonopensearchserviceDestinationUpdate
                    .build() : null;
        }

        @Override
        public final Builder amazonopensearchserviceDestinationUpdate(
                AmazonopensearchserviceDestinationUpdate amazonopensearchserviceDestinationUpdate) {
            this.amazonopensearchserviceDestinationUpdate = amazonopensearchserviceDestinationUpdate;
            return this;
        }

        public final SplunkDestinationUpdate.Builder getSplunkDestinationUpdate() {
            return splunkDestinationUpdate != null ? splunkDestinationUpdate.toBuilder() : null;
        }

        public final void setSplunkDestinationUpdate(SplunkDestinationUpdate.BuilderImpl splunkDestinationUpdate) {
            this.splunkDestinationUpdate = splunkDestinationUpdate != null ? splunkDestinationUpdate.build() : null;
        }

        @Override
        public final Builder splunkDestinationUpdate(SplunkDestinationUpdate splunkDestinationUpdate) {
            this.splunkDestinationUpdate = splunkDestinationUpdate;
            return this;
        }

        public final HttpEndpointDestinationUpdate.Builder getHttpEndpointDestinationUpdate() {
            return httpEndpointDestinationUpdate != null ? httpEndpointDestinationUpdate.toBuilder() : null;
        }

        public final void setHttpEndpointDestinationUpdate(HttpEndpointDestinationUpdate.BuilderImpl httpEndpointDestinationUpdate) {
            this.httpEndpointDestinationUpdate = httpEndpointDestinationUpdate != null ? httpEndpointDestinationUpdate.build()
                    : null;
        }

        @Override
        public final Builder httpEndpointDestinationUpdate(HttpEndpointDestinationUpdate httpEndpointDestinationUpdate) {
            this.httpEndpointDestinationUpdate = httpEndpointDestinationUpdate;
            return this;
        }

        public final AmazonOpenSearchServerlessDestinationUpdate.Builder getAmazonOpenSearchServerlessDestinationUpdate() {
            return amazonOpenSearchServerlessDestinationUpdate != null ? amazonOpenSearchServerlessDestinationUpdate.toBuilder()
                    : null;
        }

        public final void setAmazonOpenSearchServerlessDestinationUpdate(
                AmazonOpenSearchServerlessDestinationUpdate.BuilderImpl amazonOpenSearchServerlessDestinationUpdate) {
            this.amazonOpenSearchServerlessDestinationUpdate = amazonOpenSearchServerlessDestinationUpdate != null ? amazonOpenSearchServerlessDestinationUpdate
                    .build() : null;
        }

        @Override
        public final Builder amazonOpenSearchServerlessDestinationUpdate(
                AmazonOpenSearchServerlessDestinationUpdate amazonOpenSearchServerlessDestinationUpdate) {
            this.amazonOpenSearchServerlessDestinationUpdate = amazonOpenSearchServerlessDestinationUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
