/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus;
import software.amazon.awssdk.services.firehose.model.FailureDescription;
import software.amazon.awssdk.services.firehose.model.KeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeliveryStreamEncryptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeliveryStreamEncryptionConfiguration> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyARN").getter(DeliveryStreamEncryptionConfiguration.getter(DeliveryStreamEncryptionConfiguration::keyARN)).setter(DeliveryStreamEncryptionConfiguration.setter(Builder::keyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyARN").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(DeliveryStreamEncryptionConfiguration.getter(DeliveryStreamEncryptionConfiguration::keyTypeAsString)).setter(DeliveryStreamEncryptionConfiguration.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DeliveryStreamEncryptionConfiguration.getter(DeliveryStreamEncryptionConfiguration::statusAsString)).setter(DeliveryStreamEncryptionConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<FailureDescription> FAILURE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDescription").getter(DeliveryStreamEncryptionConfiguration.getter(DeliveryStreamEncryptionConfiguration::failureDescription)).setter(DeliveryStreamEncryptionConfiguration.setter(Builder::failureDescription)).constructor(FailureDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_TYPE_FIELD, STATUS_FIELD, FAILURE_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyARN;
    private final String keyType;
    private final String status;
    private final FailureDescription failureDescription;

    private DeliveryStreamEncryptionConfiguration(BuilderImpl builder) {
        this.keyARN = builder.keyARN;
        this.keyType = builder.keyType;
        this.status = builder.status;
        this.failureDescription = builder.failureDescription;
    }

    public final String keyARN() {
        return this.keyARN;
    }

    public final KeyType keyType() {
        return KeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public final DeliveryStreamEncryptionStatus status() {
        return DeliveryStreamEncryptionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final FailureDescription failureDescription() {
        return this.failureDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamEncryptionConfiguration)) {
            return false;
        }
        DeliveryStreamEncryptionConfiguration other = (DeliveryStreamEncryptionConfiguration)obj;
        return Objects.equals(this.keyARN(), other.keyARN()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureDescription(), other.failureDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DeliveryStreamEncryptionConfiguration").add("KeyARN", (Object)this.keyARN()).add("KeyType", (Object)this.keyTypeAsString()).add("Status", (Object)this.statusAsString()).add("FailureDescription", (Object)this.failureDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyARN": {
                return Optional.ofNullable(clazz.cast(this.keyARN()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureDescription": {
                return Optional.ofNullable(clazz.cast(this.failureDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryStreamEncryptionConfiguration, T> g) {
        return obj -> g.apply((DeliveryStreamEncryptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyARN;
        private String keyType;
        private String status;
        private FailureDescription failureDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamEncryptionConfiguration model) {
            this.keyARN(model.keyARN);
            this.keyType(model.keyType);
            this.status(model.status);
            this.failureDescription(model.failureDescription);
        }

        public final String getKeyARN() {
            return this.keyARN;
        }

        @Override
        public final Builder keyARN(String keyARN) {
            this.keyARN = keyARN;
            return this;
        }

        public final void setKeyARN(String keyARN) {
            this.keyARN = keyARN;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeliveryStreamEncryptionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final FailureDescription.Builder getFailureDescription() {
            return this.failureDescription != null ? this.failureDescription.toBuilder() : null;
        }

        @Override
        public final Builder failureDescription(FailureDescription failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        public final void setFailureDescription(FailureDescription.BuilderImpl failureDescription) {
            this.failureDescription = failureDescription != null ? failureDescription.build() : null;
        }

        public DeliveryStreamEncryptionConfiguration build() {
            return new DeliveryStreamEncryptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeliveryStreamEncryptionConfiguration> {
        public Builder keyARN(String var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);

        public Builder status(String var1);

        public Builder status(DeliveryStreamEncryptionStatus var1);

        public Builder failureDescription(FailureDescription var1);

        default public Builder failureDescription(Consumer<FailureDescription.Builder> failureDescription) {
            return this.failureDescription((FailureDescription)((FailureDescription.Builder)FailureDescription.builder().applyMutation(failureDescription)).build());
        }
    }
}

