/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftRetryOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftRetryOptions.Builder, RedshiftRetryOptions> {
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(RedshiftRetryOptions::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer durationInSeconds;

    private RedshiftRetryOptions(BuilderImpl builder) {
        this.durationInSeconds = builder.durationInSeconds;
    }

    /**
     * <p>
     * The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from the initial
     * request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis Data Firehose
     * does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes
     * longer than the current value.
     * </p>
     * 
     * @return The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from the
     *         initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis
     *         Data Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first
     *         delivery attempt takes longer than the current value.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftRetryOptions)) {
            return false;
        }
        RedshiftRetryOptions other = (RedshiftRetryOptions) obj;
        return Objects.equals(durationInSeconds(), other.durationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftRetryOptions").add("DurationInSeconds", durationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftRetryOptions, T> g) {
        return obj -> g.apply((RedshiftRetryOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftRetryOptions> {
        /**
         * <p>
         * The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from the
         * initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis Data
         * Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery
         * attempt takes longer than the current value.
         * </p>
         * 
         * @param durationInSeconds
         *        The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from
         *        the initial request and including the first attempt. The default value is 3600 seconds (60 minutes).
         *        Kinesis Data Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if
         *        the first delivery attempt takes longer than the current value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftRetryOptions model) {
            durationInSeconds(model.durationInSeconds);
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public RedshiftRetryOptions build() {
            return new RedshiftRetryOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
