/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon CloudWatch logging options for your delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLoggingOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLoggingOptions.Builder, CloudWatchLoggingOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CloudWatchLoggingOptions::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupName").getter(getter(CloudWatchLoggingOptions::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()).build();

    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStreamName").getter(getter(CloudWatchLoggingOptions::logStreamName))
            .setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            LOG_GROUP_NAME_FIELD, LOG_STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String logGroupName;

    private final String logStreamName;

    private CloudWatchLoggingOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
    }

    /**
     * <p>
     * Enables or disables CloudWatch logging.
     * </p>
     * 
     * @return Enables or disables CloudWatch logging.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.
     * </p>
     * 
     * @return The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.
     * </p>
     * 
     * @return The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.
     */
    public final String logStreamName() {
        return logStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptions)) {
            return false;
        }
        CloudWatchLoggingOptions other = (CloudWatchLoggingOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(logStreamName(), other.logStreamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLoggingOptions").add("Enabled", enabled()).add("LogGroupName", logGroupName())
                .add("LogStreamName", logStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "LogStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingOptions, T> g) {
        return obj -> g.apply((CloudWatchLoggingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLoggingOptions> {
        /**
         * <p>
         * Enables or disables CloudWatch logging.
         * </p>
         * 
         * @param enabled
         *        Enables or disables CloudWatch logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.
         * </p>
         * 
         * @param logGroupName
         *        The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.
         * </p>
         * 
         * @param logStreamName
         *        The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String logGroupName;

        private String logStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptions model) {
            enabled(model.enabled);
            logGroupName(model.logGroupName);
            logStreamName(model.logStreamName);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public CloudWatchLoggingOptions build() {
            return new CloudWatchLoggingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
