/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationPermission {
    CREATE_DATASET("CreateDataset"),
    MANAGE_CLUSTERS("ManageClusters"),
    MANAGE_USERS_AND_GROUPS("ManageUsersAndGroups"),
    MANAGE_ATTRIBUTE_SETS("ManageAttributeSets"),
    VIEW_AUDIT_DATA("ViewAuditData"),
    ACCESS_NOTEBOOKS("AccessNotebooks"),
    GET_TEMPORARY_CREDENTIALS("GetTemporaryCredentials"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationPermission> VALUE_MAP;
    private final String value;

    private ApplicationPermission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationPermission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationPermission> knownValues() {
        EnumSet<ApplicationPermission> knownValues = EnumSet.allOf(ApplicationPermission.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationPermission.class, ApplicationPermission::toString);
    }
}

