/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.DataViewDestinationTypeParams;
import software.amazon.awssdk.services.finspacedata.model.DataViewErrorInfo;
import software.amazon.awssdk.services.finspacedata.model.DataViewStatus;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.services.finspacedata.model.PartitionColumnListCopier;
import software.amazon.awssdk.services.finspacedata.model.SortColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataViewResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, GetDataViewResponse> {
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoUpdate").getter(GetDataViewResponse.getter(GetDataViewResponse::autoUpdate)).setter(GetDataViewResponse.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()}).build();
    private static final SdkField<List<String>> PARTITION_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("partitionColumns").getter(GetDataViewResponse.getter(GetDataViewResponse::partitionColumns)).setter(GetDataViewResponse.setter(Builder::partitionColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(GetDataViewResponse.getter(GetDataViewResponse::datasetId)).setter(GetDataViewResponse.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()}).build();
    private static final SdkField<Long> AS_OF_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("asOfTimestamp").getter(GetDataViewResponse.getter(GetDataViewResponse::asOfTimestamp)).setter(GetDataViewResponse.setter(Builder::asOfTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asOfTimestamp").build()}).build();
    private static final SdkField<DataViewErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(GetDataViewResponse.getter(GetDataViewResponse::errorInfo)).setter(GetDataViewResponse.setter(Builder::errorInfo)).constructor(DataViewErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTime").getter(GetDataViewResponse.getter(GetDataViewResponse::lastModifiedTime)).setter(GetDataViewResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createTime").getter(GetDataViewResponse.getter(GetDataViewResponse::createTime)).setter(GetDataViewResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<List<String>> SORT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sortColumns").getter(GetDataViewResponse.getter(GetDataViewResponse::sortColumns)).setter(GetDataViewResponse.setter(Builder::sortColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataViewId").getter(GetDataViewResponse.getter(GetDataViewResponse::dataViewId)).setter(GetDataViewResponse.setter(Builder::dataViewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViewId").build()}).build();
    private static final SdkField<String> DATA_VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataViewArn").getter(GetDataViewResponse.getter(GetDataViewResponse::dataViewArn)).setter(GetDataViewResponse.setter(Builder::dataViewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViewArn").build()}).build();
    private static final SdkField<DataViewDestinationTypeParams> DESTINATION_TYPE_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationTypeParams").getter(GetDataViewResponse.getter(GetDataViewResponse::destinationTypeParams)).setter(GetDataViewResponse.setter(Builder::destinationTypeParams)).constructor(DataViewDestinationTypeParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTypeParams").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDataViewResponse.getter(GetDataViewResponse::statusAsString)).setter(GetDataViewResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_UPDATE_FIELD, PARTITION_COLUMNS_FIELD, DATASET_ID_FIELD, AS_OF_TIMESTAMP_FIELD, ERROR_INFO_FIELD, LAST_MODIFIED_TIME_FIELD, CREATE_TIME_FIELD, SORT_COLUMNS_FIELD, DATA_VIEW_ID_FIELD, DATA_VIEW_ARN_FIELD, DESTINATION_TYPE_PARAMS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataViewResponse.memberNameToFieldInitializer();
    private final Boolean autoUpdate;
    private final List<String> partitionColumns;
    private final String datasetId;
    private final Long asOfTimestamp;
    private final DataViewErrorInfo errorInfo;
    private final Long lastModifiedTime;
    private final Long createTime;
    private final List<String> sortColumns;
    private final String dataViewId;
    private final String dataViewArn;
    private final DataViewDestinationTypeParams destinationTypeParams;
    private final String status;

    private GetDataViewResponse(BuilderImpl builder) {
        super(builder);
        this.autoUpdate = builder.autoUpdate;
        this.partitionColumns = builder.partitionColumns;
        this.datasetId = builder.datasetId;
        this.asOfTimestamp = builder.asOfTimestamp;
        this.errorInfo = builder.errorInfo;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createTime = builder.createTime;
        this.sortColumns = builder.sortColumns;
        this.dataViewId = builder.dataViewId;
        this.dataViewArn = builder.dataViewArn;
        this.destinationTypeParams = builder.destinationTypeParams;
        this.status = builder.status;
    }

    public final Boolean autoUpdate() {
        return this.autoUpdate;
    }

    public final boolean hasPartitionColumns() {
        return this.partitionColumns != null && !(this.partitionColumns instanceof SdkAutoConstructList);
    }

    public final List<String> partitionColumns() {
        return this.partitionColumns;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final Long asOfTimestamp() {
        return this.asOfTimestamp;
    }

    public final DataViewErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Long createTime() {
        return this.createTime;
    }

    public final boolean hasSortColumns() {
        return this.sortColumns != null && !(this.sortColumns instanceof SdkAutoConstructList);
    }

    public final List<String> sortColumns() {
        return this.sortColumns;
    }

    public final String dataViewId() {
        return this.dataViewId;
    }

    public final String dataViewArn() {
        return this.dataViewArn;
    }

    public final DataViewDestinationTypeParams destinationTypeParams() {
        return this.destinationTypeParams;
    }

    public final DataViewStatus status() {
        return DataViewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionColumns() ? this.partitionColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.asOfTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortColumns() ? this.sortColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataViewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataViewResponse)) {
            return false;
        }
        GetDataViewResponse other = (GetDataViewResponse)((Object)obj);
        return Objects.equals(this.autoUpdate(), other.autoUpdate()) && this.hasPartitionColumns() == other.hasPartitionColumns() && Objects.equals(this.partitionColumns(), other.partitionColumns()) && Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.asOfTimestamp(), other.asOfTimestamp()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.createTime(), other.createTime()) && this.hasSortColumns() == other.hasSortColumns() && Objects.equals(this.sortColumns(), other.sortColumns()) && Objects.equals(this.dataViewId(), other.dataViewId()) && Objects.equals(this.dataViewArn(), other.dataViewArn()) && Objects.equals(this.destinationTypeParams(), other.destinationTypeParams()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataViewResponse").add("AutoUpdate", (Object)this.autoUpdate()).add("PartitionColumns", this.hasPartitionColumns() ? this.partitionColumns() : null).add("DatasetId", (Object)this.datasetId()).add("AsOfTimestamp", (Object)this.asOfTimestamp()).add("ErrorInfo", (Object)this.errorInfo()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreateTime", (Object)this.createTime()).add("SortColumns", this.hasSortColumns() ? this.sortColumns() : null).add("DataViewId", (Object)this.dataViewId()).add("DataViewArn", (Object)this.dataViewArn()).add("DestinationTypeParams", (Object)this.destinationTypeParams()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdate()));
            }
            case "partitionColumns": {
                return Optional.ofNullable(clazz.cast(this.partitionColumns()));
            }
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "asOfTimestamp": {
                return Optional.ofNullable(clazz.cast(this.asOfTimestamp()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "sortColumns": {
                return Optional.ofNullable(clazz.cast(this.sortColumns()));
            }
            case "dataViewId": {
                return Optional.ofNullable(clazz.cast(this.dataViewId()));
            }
            case "dataViewArn": {
                return Optional.ofNullable(clazz.cast(this.dataViewArn()));
            }
            case "destinationTypeParams": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeParams()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoUpdate", AUTO_UPDATE_FIELD);
        map.put("partitionColumns", PARTITION_COLUMNS_FIELD);
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("asOfTimestamp", AS_OF_TIMESTAMP_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("sortColumns", SORT_COLUMNS_FIELD);
        map.put("dataViewId", DATA_VIEW_ID_FIELD);
        map.put("dataViewArn", DATA_VIEW_ARN_FIELD);
        map.put("destinationTypeParams", DESTINATION_TYPE_PARAMS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataViewResponse, T> g) {
        return obj -> g.apply((GetDataViewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private Boolean autoUpdate;
        private List<String> partitionColumns = DefaultSdkAutoConstructList.getInstance();
        private String datasetId;
        private Long asOfTimestamp;
        private DataViewErrorInfo errorInfo;
        private Long lastModifiedTime;
        private Long createTime;
        private List<String> sortColumns = DefaultSdkAutoConstructList.getInstance();
        private String dataViewId;
        private String dataViewArn;
        private DataViewDestinationTypeParams destinationTypeParams;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataViewResponse model) {
            super(model);
            this.autoUpdate(model.autoUpdate);
            this.partitionColumns(model.partitionColumns);
            this.datasetId(model.datasetId);
            this.asOfTimestamp(model.asOfTimestamp);
            this.errorInfo(model.errorInfo);
            this.lastModifiedTime(model.lastModifiedTime);
            this.createTime(model.createTime);
            this.sortColumns(model.sortColumns);
            this.dataViewId(model.dataViewId);
            this.dataViewArn(model.dataViewArn);
            this.destinationTypeParams(model.destinationTypeParams);
            this.status(model.status);
        }

        public final Boolean getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Collection<String> getPartitionColumns() {
            if (this.partitionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionColumns;
        }

        public final void setPartitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
        }

        @Override
        public final Builder partitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionColumns(String ... partitionColumns) {
            this.partitionColumns(Arrays.asList(partitionColumns));
            return this;
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final Long getAsOfTimestamp() {
            return this.asOfTimestamp;
        }

        public final void setAsOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
        }

        @Override
        public final Builder asOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
            return this;
        }

        public final DataViewErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(DataViewErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(DataViewErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Collection<String> getSortColumns() {
            if (this.sortColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sortColumns;
        }

        public final void setSortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
        }

        @Override
        public final Builder sortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(String ... sortColumns) {
            this.sortColumns(Arrays.asList(sortColumns));
            return this;
        }

        public final String getDataViewId() {
            return this.dataViewId;
        }

        public final void setDataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
        }

        @Override
        public final Builder dataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
            return this;
        }

        public final String getDataViewArn() {
            return this.dataViewArn;
        }

        public final void setDataViewArn(String dataViewArn) {
            this.dataViewArn = dataViewArn;
        }

        @Override
        public final Builder dataViewArn(String dataViewArn) {
            this.dataViewArn = dataViewArn;
            return this;
        }

        public final DataViewDestinationTypeParams.Builder getDestinationTypeParams() {
            return this.destinationTypeParams != null ? this.destinationTypeParams.toBuilder() : null;
        }

        public final void setDestinationTypeParams(DataViewDestinationTypeParams.BuilderImpl destinationTypeParams) {
            this.destinationTypeParams = destinationTypeParams != null ? destinationTypeParams.build() : null;
        }

        @Override
        public final Builder destinationTypeParams(DataViewDestinationTypeParams destinationTypeParams) {
            this.destinationTypeParams = destinationTypeParams;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataViewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetDataViewResponse build() {
            return new GetDataViewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataViewResponse> {
        public Builder autoUpdate(Boolean var1);

        public Builder partitionColumns(Collection<String> var1);

        public Builder partitionColumns(String ... var1);

        public Builder datasetId(String var1);

        public Builder asOfTimestamp(Long var1);

        public Builder errorInfo(DataViewErrorInfo var1);

        default public Builder errorInfo(Consumer<DataViewErrorInfo.Builder> errorInfo) {
            return this.errorInfo((DataViewErrorInfo)((DataViewErrorInfo.Builder)DataViewErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder lastModifiedTime(Long var1);

        public Builder createTime(Long var1);

        public Builder sortColumns(Collection<String> var1);

        public Builder sortColumns(String ... var1);

        public Builder dataViewId(String var1);

        public Builder dataViewArn(String var1);

        public Builder destinationTypeParams(DataViewDestinationTypeParams var1);

        default public Builder destinationTypeParams(Consumer<DataViewDestinationTypeParams.Builder> destinationTypeParams) {
            return this.destinationTypeParams((DataViewDestinationTypeParams)((DataViewDestinationTypeParams.Builder)DataViewDestinationTypeParams.builder().applyMutation(destinationTypeParams)).build());
        }

        public Builder status(String var1);

        public Builder status(DataViewStatus var1);
    }
}

