/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.AutoScalingConfiguration;
import software.amazon.awssdk.services.finspace.model.CapacityConfiguration;
import software.amazon.awssdk.services.finspace.model.CodeConfiguration;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration;
import software.amazon.awssdk.services.finspace.model.KxCacheStorageConfigurationsCopier;
import software.amazon.awssdk.services.finspace.model.KxClusterStatus;
import software.amazon.awssdk.services.finspace.model.KxClusterType;
import software.amazon.awssdk.services.finspace.model.KxCommandLineArgument;
import software.amazon.awssdk.services.finspace.model.KxCommandLineArgumentsCopier;
import software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDatabaseConfigurationsCopier;
import software.amazon.awssdk.services.finspace.model.KxSavedownStorageConfiguration;
import software.amazon.awssdk.services.finspace.model.KxScalingGroupConfiguration;
import software.amazon.awssdk.services.finspace.model.TickerplantLogConfiguration;
import software.amazon.awssdk.services.finspace.model.Volume;
import software.amazon.awssdk.services.finspace.model.VolumesCopier;
import software.amazon.awssdk.services.finspace.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKxClusterResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, GetKxClusterResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetKxClusterResponse.getter(GetKxClusterResponse::statusAsString)).setter(GetKxClusterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetKxClusterResponse.getter(GetKxClusterResponse::statusReason)).setter(GetKxClusterResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(GetKxClusterResponse.getter(GetKxClusterResponse::clusterName)).setter(GetKxClusterResponse.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterType").getter(GetKxClusterResponse.getter(GetKxClusterResponse::clusterTypeAsString)).setter(GetKxClusterResponse.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<TickerplantLogConfiguration> TICKERPLANT_LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tickerplantLogConfiguration").getter(GetKxClusterResponse.getter(GetKxClusterResponse::tickerplantLogConfiguration)).setter(GetKxClusterResponse.setter(Builder::tickerplantLogConfiguration)).constructor(TickerplantLogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tickerplantLogConfiguration").build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumes").getter(GetKxClusterResponse.getter(GetKxClusterResponse::volumes)).setter(GetKxClusterResponse.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KxDatabaseConfiguration>> DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("databases").getter(GetKxClusterResponse.getter(GetKxClusterResponse::databases)).setter(GetKxClusterResponse.setter(Builder::databases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDatabaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KxCacheStorageConfiguration>> CACHE_STORAGE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cacheStorageConfigurations").getter(GetKxClusterResponse.getter(GetKxClusterResponse::cacheStorageConfigurations)).setter(GetKxClusterResponse.setter(Builder::cacheStorageConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheStorageConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxCacheStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoScalingConfiguration> AUTO_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoScalingConfiguration").getter(GetKxClusterResponse.getter(GetKxClusterResponse::autoScalingConfiguration)).setter(GetKxClusterResponse.setter(Builder::autoScalingConfiguration)).constructor(AutoScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingConfiguration").build()}).build();
    private static final SdkField<String> CLUSTER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterDescription").getter(GetKxClusterResponse.getter(GetKxClusterResponse::clusterDescription)).setter(GetKxClusterResponse.setter(Builder::clusterDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterDescription").build()}).build();
    private static final SdkField<CapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacityConfiguration").getter(GetKxClusterResponse.getter(GetKxClusterResponse::capacityConfiguration)).setter(GetKxClusterResponse.setter(Builder::capacityConfiguration)).constructor(CapacityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(GetKxClusterResponse.getter(GetKxClusterResponse::releaseLabel)).setter(GetKxClusterResponse.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(GetKxClusterResponse.getter(GetKxClusterResponse::vpcConfiguration)).setter(GetKxClusterResponse.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final SdkField<String> INITIALIZATION_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initializationScript").getter(GetKxClusterResponse.getter(GetKxClusterResponse::initializationScript)).setter(GetKxClusterResponse.setter(Builder::initializationScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScript").build()}).build();
    private static final SdkField<List<KxCommandLineArgument>> COMMAND_LINE_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commandLineArguments").getter(GetKxClusterResponse.getter(GetKxClusterResponse::commandLineArguments)).setter(GetKxClusterResponse.setter(Builder::commandLineArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandLineArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxCommandLineArgument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CodeConfiguration> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("code").getter(GetKxClusterResponse.getter(GetKxClusterResponse::code)).setter(GetKxClusterResponse.setter(Builder::code)).constructor(CodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(GetKxClusterResponse.getter(GetKxClusterResponse::executionRole)).setter(GetKxClusterResponse.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(GetKxClusterResponse.getter(GetKxClusterResponse::lastModifiedTimestamp)).setter(GetKxClusterResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<KxSavedownStorageConfiguration> SAVEDOWN_STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savedownStorageConfiguration").getter(GetKxClusterResponse.getter(GetKxClusterResponse::savedownStorageConfiguration)).setter(GetKxClusterResponse.setter(Builder::savedownStorageConfiguration)).constructor(KxSavedownStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savedownStorageConfiguration").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(GetKxClusterResponse.getter(GetKxClusterResponse::azModeAsString)).setter(GetKxClusterResponse.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(GetKxClusterResponse.getter(GetKxClusterResponse::availabilityZoneId)).setter(GetKxClusterResponse.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(GetKxClusterResponse.getter(GetKxClusterResponse::createdTimestamp)).setter(GetKxClusterResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<KxScalingGroupConfiguration> SCALING_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingGroupConfiguration").getter(GetKxClusterResponse.getter(GetKxClusterResponse::scalingGroupConfiguration)).setter(GetKxClusterResponse.setter(Builder::scalingGroupConfiguration)).constructor(KxScalingGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_REASON_FIELD, CLUSTER_NAME_FIELD, CLUSTER_TYPE_FIELD, TICKERPLANT_LOG_CONFIGURATION_FIELD, VOLUMES_FIELD, DATABASES_FIELD, CACHE_STORAGE_CONFIGURATIONS_FIELD, AUTO_SCALING_CONFIGURATION_FIELD, CLUSTER_DESCRIPTION_FIELD, CAPACITY_CONFIGURATION_FIELD, RELEASE_LABEL_FIELD, VPC_CONFIGURATION_FIELD, INITIALIZATION_SCRIPT_FIELD, COMMAND_LINE_ARGUMENTS_FIELD, CODE_FIELD, EXECUTION_ROLE_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, SAVEDOWN_STORAGE_CONFIGURATION_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CREATED_TIMESTAMP_FIELD, SCALING_GROUP_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetKxClusterResponse.memberNameToFieldInitializer();
    private final String status;
    private final String statusReason;
    private final String clusterName;
    private final String clusterType;
    private final TickerplantLogConfiguration tickerplantLogConfiguration;
    private final List<Volume> volumes;
    private final List<KxDatabaseConfiguration> databases;
    private final List<KxCacheStorageConfiguration> cacheStorageConfigurations;
    private final AutoScalingConfiguration autoScalingConfiguration;
    private final String clusterDescription;
    private final CapacityConfiguration capacityConfiguration;
    private final String releaseLabel;
    private final VpcConfiguration vpcConfiguration;
    private final String initializationScript;
    private final List<KxCommandLineArgument> commandLineArguments;
    private final CodeConfiguration code;
    private final String executionRole;
    private final Instant lastModifiedTimestamp;
    private final KxSavedownStorageConfiguration savedownStorageConfiguration;
    private final String azMode;
    private final String availabilityZoneId;
    private final Instant createdTimestamp;
    private final KxScalingGroupConfiguration scalingGroupConfiguration;

    private GetKxClusterResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.clusterName = builder.clusterName;
        this.clusterType = builder.clusterType;
        this.tickerplantLogConfiguration = builder.tickerplantLogConfiguration;
        this.volumes = builder.volumes;
        this.databases = builder.databases;
        this.cacheStorageConfigurations = builder.cacheStorageConfigurations;
        this.autoScalingConfiguration = builder.autoScalingConfiguration;
        this.clusterDescription = builder.clusterDescription;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.releaseLabel = builder.releaseLabel;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.initializationScript = builder.initializationScript;
        this.commandLineArguments = builder.commandLineArguments;
        this.code = builder.code;
        this.executionRole = builder.executionRole;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.savedownStorageConfiguration = builder.savedownStorageConfiguration;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.createdTimestamp = builder.createdTimestamp;
        this.scalingGroupConfiguration = builder.scalingGroupConfiguration;
    }

    public final KxClusterStatus status() {
        return KxClusterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final KxClusterType clusterType() {
        return KxClusterType.fromValue(this.clusterType);
    }

    public final String clusterTypeAsString() {
        return this.clusterType;
    }

    public final TickerplantLogConfiguration tickerplantLogConfiguration() {
        return this.tickerplantLogConfiguration;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<Volume> volumes() {
        return this.volumes;
    }

    public final boolean hasDatabases() {
        return this.databases != null && !(this.databases instanceof SdkAutoConstructList);
    }

    public final List<KxDatabaseConfiguration> databases() {
        return this.databases;
    }

    public final boolean hasCacheStorageConfigurations() {
        return this.cacheStorageConfigurations != null && !(this.cacheStorageConfigurations instanceof SdkAutoConstructList);
    }

    public final List<KxCacheStorageConfiguration> cacheStorageConfigurations() {
        return this.cacheStorageConfigurations;
    }

    public final AutoScalingConfiguration autoScalingConfiguration() {
        return this.autoScalingConfiguration;
    }

    public final String clusterDescription() {
        return this.clusterDescription;
    }

    public final CapacityConfiguration capacityConfiguration() {
        return this.capacityConfiguration;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final String initializationScript() {
        return this.initializationScript;
    }

    public final boolean hasCommandLineArguments() {
        return this.commandLineArguments != null && !(this.commandLineArguments instanceof SdkAutoConstructList);
    }

    public final List<KxCommandLineArgument> commandLineArguments() {
        return this.commandLineArguments;
    }

    public final CodeConfiguration code() {
        return this.code;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final KxSavedownStorageConfiguration savedownStorageConfiguration() {
        return this.savedownStorageConfiguration;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final KxScalingGroupConfiguration scalingGroupConfiguration() {
        return this.scalingGroupConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tickerplantLogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabases() ? this.databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheStorageConfigurations() ? this.cacheStorageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommandLineArguments() ? this.commandLineArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.savedownStorageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingGroupConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxClusterResponse)) {
            return false;
        }
        GetKxClusterResponse other = (GetKxClusterResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clusterTypeAsString(), other.clusterTypeAsString()) && Objects.equals(this.tickerplantLogConfiguration(), other.tickerplantLogConfiguration()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && this.hasDatabases() == other.hasDatabases() && Objects.equals(this.databases(), other.databases()) && this.hasCacheStorageConfigurations() == other.hasCacheStorageConfigurations() && Objects.equals(this.cacheStorageConfigurations(), other.cacheStorageConfigurations()) && Objects.equals(this.autoScalingConfiguration(), other.autoScalingConfiguration()) && Objects.equals(this.clusterDescription(), other.clusterDescription()) && Objects.equals(this.capacityConfiguration(), other.capacityConfiguration()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.initializationScript(), other.initializationScript()) && this.hasCommandLineArguments() == other.hasCommandLineArguments() && Objects.equals(this.commandLineArguments(), other.commandLineArguments()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.savedownStorageConfiguration(), other.savedownStorageConfiguration()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.scalingGroupConfiguration(), other.scalingGroupConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetKxClusterResponse").add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("ClusterName", (Object)this.clusterName()).add("ClusterType", (Object)this.clusterTypeAsString()).add("TickerplantLogConfiguration", (Object)this.tickerplantLogConfiguration()).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("Databases", this.hasDatabases() ? this.databases() : null).add("CacheStorageConfigurations", this.hasCacheStorageConfigurations() ? this.cacheStorageConfigurations() : null).add("AutoScalingConfiguration", (Object)this.autoScalingConfiguration()).add("ClusterDescription", (Object)this.clusterDescription()).add("CapacityConfiguration", (Object)this.capacityConfiguration()).add("ReleaseLabel", (Object)this.releaseLabel()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("InitializationScript", (Object)this.initializationScript()).add("CommandLineArguments", this.hasCommandLineArguments() ? this.commandLineArguments() : null).add("Code", (Object)this.code()).add("ExecutionRole", (Object)this.executionRole()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("SavedownStorageConfiguration", (Object)this.savedownStorageConfiguration()).add("AzMode", (Object)this.azModeAsString()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("ScalingGroupConfiguration", (Object)this.scalingGroupConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "clusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeAsString()));
            }
            case "tickerplantLogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.tickerplantLogConfiguration()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "databases": {
                return Optional.ofNullable(clazz.cast(this.databases()));
            }
            case "cacheStorageConfigurations": {
                return Optional.ofNullable(clazz.cast(this.cacheStorageConfigurations()));
            }
            case "autoScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfiguration()));
            }
            case "clusterDescription": {
                return Optional.ofNullable(clazz.cast(this.clusterDescription()));
            }
            case "capacityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.capacityConfiguration()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "initializationScript": {
                return Optional.ofNullable(clazz.cast(this.initializationScript()));
            }
            case "commandLineArguments": {
                return Optional.ofNullable(clazz.cast(this.commandLineArguments()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "savedownStorageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.savedownStorageConfiguration()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "scalingGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingGroupConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("tickerplantLogConfiguration", TICKERPLANT_LOG_CONFIGURATION_FIELD);
        map.put("volumes", VOLUMES_FIELD);
        map.put("databases", DATABASES_FIELD);
        map.put("cacheStorageConfigurations", CACHE_STORAGE_CONFIGURATIONS_FIELD);
        map.put("autoScalingConfiguration", AUTO_SCALING_CONFIGURATION_FIELD);
        map.put("clusterDescription", CLUSTER_DESCRIPTION_FIELD);
        map.put("capacityConfiguration", CAPACITY_CONFIGURATION_FIELD);
        map.put("releaseLabel", RELEASE_LABEL_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("initializationScript", INITIALIZATION_SCRIPT_FIELD);
        map.put("commandLineArguments", COMMAND_LINE_ARGUMENTS_FIELD);
        map.put("code", CODE_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("savedownStorageConfiguration", SAVEDOWN_STORAGE_CONFIGURATION_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("scalingGroupConfiguration", SCALING_GROUP_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetKxClusterResponse, T> g) {
        return obj -> g.apply((GetKxClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String status;
        private String statusReason;
        private String clusterName;
        private String clusterType;
        private TickerplantLogConfiguration tickerplantLogConfiguration;
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private List<KxDatabaseConfiguration> databases = DefaultSdkAutoConstructList.getInstance();
        private List<KxCacheStorageConfiguration> cacheStorageConfigurations = DefaultSdkAutoConstructList.getInstance();
        private AutoScalingConfiguration autoScalingConfiguration;
        private String clusterDescription;
        private CapacityConfiguration capacityConfiguration;
        private String releaseLabel;
        private VpcConfiguration vpcConfiguration;
        private String initializationScript;
        private List<KxCommandLineArgument> commandLineArguments = DefaultSdkAutoConstructList.getInstance();
        private CodeConfiguration code;
        private String executionRole;
        private Instant lastModifiedTimestamp;
        private KxSavedownStorageConfiguration savedownStorageConfiguration;
        private String azMode;
        private String availabilityZoneId;
        private Instant createdTimestamp;
        private KxScalingGroupConfiguration scalingGroupConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxClusterResponse model) {
            super(model);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.clusterName(model.clusterName);
            this.clusterType(model.clusterType);
            this.tickerplantLogConfiguration(model.tickerplantLogConfiguration);
            this.volumes(model.volumes);
            this.databases(model.databases);
            this.cacheStorageConfigurations(model.cacheStorageConfigurations);
            this.autoScalingConfiguration(model.autoScalingConfiguration);
            this.clusterDescription(model.clusterDescription);
            this.capacityConfiguration(model.capacityConfiguration);
            this.releaseLabel(model.releaseLabel);
            this.vpcConfiguration(model.vpcConfiguration);
            this.initializationScript(model.initializationScript);
            this.commandLineArguments(model.commandLineArguments);
            this.code(model.code);
            this.executionRole(model.executionRole);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.savedownStorageConfiguration(model.savedownStorageConfiguration);
            this.azMode(model.azMode);
            this.availabilityZoneId(model.availabilityZoneId);
            this.createdTimestamp(model.createdTimestamp);
            this.scalingGroupConfiguration(model.scalingGroupConfiguration);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(KxClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final TickerplantLogConfiguration.Builder getTickerplantLogConfiguration() {
            return this.tickerplantLogConfiguration != null ? this.tickerplantLogConfiguration.toBuilder() : null;
        }

        public final void setTickerplantLogConfiguration(TickerplantLogConfiguration.BuilderImpl tickerplantLogConfiguration) {
            this.tickerplantLogConfiguration = tickerplantLogConfiguration != null ? tickerplantLogConfiguration.build() : null;
        }

        @Override
        public final Builder tickerplantLogConfiguration(TickerplantLogConfiguration tickerplantLogConfiguration) {
            this.tickerplantLogConfiguration = tickerplantLogConfiguration;
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KxDatabaseConfiguration.Builder> getDatabases() {
            List<KxDatabaseConfiguration.Builder> result = KxDatabaseConfigurationsCopier.copyToBuilder(this.databases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabases(Collection<KxDatabaseConfiguration.BuilderImpl> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copyFromBuilder(databases);
        }

        @Override
        public final Builder databases(Collection<KxDatabaseConfiguration> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(KxDatabaseConfiguration ... databases) {
            this.databases(Arrays.asList(databases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(Consumer<KxDatabaseConfiguration.Builder> ... databases) {
            this.databases(Stream.of(databases).map(c -> (KxDatabaseConfiguration)((KxDatabaseConfiguration.Builder)KxDatabaseConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KxCacheStorageConfiguration.Builder> getCacheStorageConfigurations() {
            List<KxCacheStorageConfiguration.Builder> result = KxCacheStorageConfigurationsCopier.copyToBuilder(this.cacheStorageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheStorageConfigurations(Collection<KxCacheStorageConfiguration.BuilderImpl> cacheStorageConfigurations) {
            this.cacheStorageConfigurations = KxCacheStorageConfigurationsCopier.copyFromBuilder(cacheStorageConfigurations);
        }

        @Override
        public final Builder cacheStorageConfigurations(Collection<KxCacheStorageConfiguration> cacheStorageConfigurations) {
            this.cacheStorageConfigurations = KxCacheStorageConfigurationsCopier.copy(cacheStorageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheStorageConfigurations(KxCacheStorageConfiguration ... cacheStorageConfigurations) {
            this.cacheStorageConfigurations(Arrays.asList(cacheStorageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheStorageConfigurations(Consumer<KxCacheStorageConfiguration.Builder> ... cacheStorageConfigurations) {
            this.cacheStorageConfigurations(Stream.of(cacheStorageConfigurations).map(c -> (KxCacheStorageConfiguration)((KxCacheStorageConfiguration.Builder)KxCacheStorageConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoScalingConfiguration.Builder getAutoScalingConfiguration() {
            return this.autoScalingConfiguration != null ? this.autoScalingConfiguration.toBuilder() : null;
        }

        public final void setAutoScalingConfiguration(AutoScalingConfiguration.BuilderImpl autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration != null ? autoScalingConfiguration.build() : null;
        }

        @Override
        public final Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
            return this;
        }

        public final String getClusterDescription() {
            return this.clusterDescription;
        }

        public final void setClusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
        }

        @Override
        public final Builder clusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
            return this;
        }

        public final CapacityConfiguration.Builder getCapacityConfiguration() {
            return this.capacityConfiguration != null ? this.capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(CapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(CapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getInitializationScript() {
            return this.initializationScript;
        }

        public final void setInitializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
        }

        @Override
        public final Builder initializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
            return this;
        }

        public final List<KxCommandLineArgument.Builder> getCommandLineArguments() {
            List<KxCommandLineArgument.Builder> result = KxCommandLineArgumentsCopier.copyToBuilder(this.commandLineArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommandLineArguments(Collection<KxCommandLineArgument.BuilderImpl> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copyFromBuilder(commandLineArguments);
        }

        @Override
        public final Builder commandLineArguments(Collection<KxCommandLineArgument> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copy(commandLineArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(KxCommandLineArgument ... commandLineArguments) {
            this.commandLineArguments(Arrays.asList(commandLineArguments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder> ... commandLineArguments) {
            this.commandLineArguments(Stream.of(commandLineArguments).map(c -> (KxCommandLineArgument)((KxCommandLineArgument.Builder)KxCommandLineArgument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CodeConfiguration.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(CodeConfiguration.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CodeConfiguration code) {
            this.code = code;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final KxSavedownStorageConfiguration.Builder getSavedownStorageConfiguration() {
            return this.savedownStorageConfiguration != null ? this.savedownStorageConfiguration.toBuilder() : null;
        }

        public final void setSavedownStorageConfiguration(KxSavedownStorageConfiguration.BuilderImpl savedownStorageConfiguration) {
            this.savedownStorageConfiguration = savedownStorageConfiguration != null ? savedownStorageConfiguration.build() : null;
        }

        @Override
        public final Builder savedownStorageConfiguration(KxSavedownStorageConfiguration savedownStorageConfiguration) {
            this.savedownStorageConfiguration = savedownStorageConfiguration;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final KxScalingGroupConfiguration.Builder getScalingGroupConfiguration() {
            return this.scalingGroupConfiguration != null ? this.scalingGroupConfiguration.toBuilder() : null;
        }

        public final void setScalingGroupConfiguration(KxScalingGroupConfiguration.BuilderImpl scalingGroupConfiguration) {
            this.scalingGroupConfiguration = scalingGroupConfiguration != null ? scalingGroupConfiguration.build() : null;
        }

        @Override
        public final Builder scalingGroupConfiguration(KxScalingGroupConfiguration scalingGroupConfiguration) {
            this.scalingGroupConfiguration = scalingGroupConfiguration;
            return this;
        }

        @Override
        public GetKxClusterResponse build() {
            return new GetKxClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKxClusterResponse> {
        public Builder status(String var1);

        public Builder status(KxClusterStatus var1);

        public Builder statusReason(String var1);

        public Builder clusterName(String var1);

        public Builder clusterType(String var1);

        public Builder clusterType(KxClusterType var1);

        public Builder tickerplantLogConfiguration(TickerplantLogConfiguration var1);

        default public Builder tickerplantLogConfiguration(Consumer<TickerplantLogConfiguration.Builder> tickerplantLogConfiguration) {
            return this.tickerplantLogConfiguration((TickerplantLogConfiguration)((TickerplantLogConfiguration.Builder)TickerplantLogConfiguration.builder().applyMutation(tickerplantLogConfiguration)).build());
        }

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder databases(Collection<KxDatabaseConfiguration> var1);

        public Builder databases(KxDatabaseConfiguration ... var1);

        public Builder databases(Consumer<KxDatabaseConfiguration.Builder> ... var1);

        public Builder cacheStorageConfigurations(Collection<KxCacheStorageConfiguration> var1);

        public Builder cacheStorageConfigurations(KxCacheStorageConfiguration ... var1);

        public Builder cacheStorageConfigurations(Consumer<KxCacheStorageConfiguration.Builder> ... var1);

        public Builder autoScalingConfiguration(AutoScalingConfiguration var1);

        default public Builder autoScalingConfiguration(Consumer<AutoScalingConfiguration.Builder> autoScalingConfiguration) {
            return this.autoScalingConfiguration((AutoScalingConfiguration)((AutoScalingConfiguration.Builder)AutoScalingConfiguration.builder().applyMutation(autoScalingConfiguration)).build());
        }

        public Builder clusterDescription(String var1);

        public Builder capacityConfiguration(CapacityConfiguration var1);

        default public Builder capacityConfiguration(Consumer<CapacityConfiguration.Builder> capacityConfiguration) {
            return this.capacityConfiguration((CapacityConfiguration)((CapacityConfiguration.Builder)CapacityConfiguration.builder().applyMutation(capacityConfiguration)).build());
        }

        public Builder releaseLabel(String var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder initializationScript(String var1);

        public Builder commandLineArguments(Collection<KxCommandLineArgument> var1);

        public Builder commandLineArguments(KxCommandLineArgument ... var1);

        public Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder> ... var1);

        public Builder code(CodeConfiguration var1);

        default public Builder code(Consumer<CodeConfiguration.Builder> code) {
            return this.code((CodeConfiguration)((CodeConfiguration.Builder)CodeConfiguration.builder().applyMutation(code)).build());
        }

        public Builder executionRole(String var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder savedownStorageConfiguration(KxSavedownStorageConfiguration var1);

        default public Builder savedownStorageConfiguration(Consumer<KxSavedownStorageConfiguration.Builder> savedownStorageConfiguration) {
            return this.savedownStorageConfiguration((KxSavedownStorageConfiguration)((KxSavedownStorageConfiguration.Builder)KxSavedownStorageConfiguration.builder().applyMutation(savedownStorageConfiguration)).build());
        }

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder availabilityZoneId(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder scalingGroupConfiguration(KxScalingGroupConfiguration var1);

        default public Builder scalingGroupConfiguration(Consumer<KxScalingGroupConfiguration.Builder> scalingGroupConfiguration) {
            return this.scalingGroupConfiguration((KxScalingGroupConfiguration)((KxScalingGroupConfiguration.Builder)KxScalingGroupConfiguration.builder().applyMutation(scalingGroupConfiguration)).build());
        }
    }
}

