/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.SegmentConfigurationDbPathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxDataviewSegmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxDataviewSegmentConfiguration> {
    private static final SdkField<List<String>> DB_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbPaths").getter(KxDataviewSegmentConfiguration.getter(KxDataviewSegmentConfiguration::dbPaths)).setter(KxDataviewSegmentConfiguration.setter(Builder::dbPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeName").getter(KxDataviewSegmentConfiguration.getter(KxDataviewSegmentConfiguration::volumeName)).setter(KxDataviewSegmentConfiguration.setter(Builder::volumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeName").build()}).build();
    private static final SdkField<Boolean> ON_DEMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("onDemand").getter(KxDataviewSegmentConfiguration.getter(KxDataviewSegmentConfiguration::onDemand)).setter(KxDataviewSegmentConfiguration.setter(Builder::onDemand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onDemand").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PATHS_FIELD, VOLUME_NAME_FIELD, ON_DEMAND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KxDataviewSegmentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> dbPaths;
    private final String volumeName;
    private final Boolean onDemand;

    private KxDataviewSegmentConfiguration(BuilderImpl builder) {
        this.dbPaths = builder.dbPaths;
        this.volumeName = builder.volumeName;
        this.onDemand = builder.onDemand;
    }

    public final boolean hasDbPaths() {
        return this.dbPaths != null && !(this.dbPaths instanceof SdkAutoConstructList);
    }

    public final List<String> dbPaths() {
        return this.dbPaths;
    }

    public final String volumeName() {
        return this.volumeName;
    }

    public final Boolean onDemand() {
        return this.onDemand;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbPaths() ? this.dbPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemand());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDataviewSegmentConfiguration)) {
            return false;
        }
        KxDataviewSegmentConfiguration other = (KxDataviewSegmentConfiguration)obj;
        return this.hasDbPaths() == other.hasDbPaths() && Objects.equals(this.dbPaths(), other.dbPaths()) && Objects.equals(this.volumeName(), other.volumeName()) && Objects.equals(this.onDemand(), other.onDemand());
    }

    public final String toString() {
        return ToString.builder((String)"KxDataviewSegmentConfiguration").add("DbPaths", this.hasDbPaths() ? this.dbPaths() : null).add("VolumeName", (Object)this.volumeName()).add("OnDemand", (Object)this.onDemand()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbPaths": {
                return Optional.ofNullable(clazz.cast(this.dbPaths()));
            }
            case "volumeName": {
                return Optional.ofNullable(clazz.cast(this.volumeName()));
            }
            case "onDemand": {
                return Optional.ofNullable(clazz.cast(this.onDemand()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbPaths", DB_PATHS_FIELD);
        map.put("volumeName", VOLUME_NAME_FIELD);
        map.put("onDemand", ON_DEMAND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxDataviewSegmentConfiguration, T> g) {
        return obj -> g.apply((KxDataviewSegmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> dbPaths = DefaultSdkAutoConstructList.getInstance();
        private String volumeName;
        private Boolean onDemand;

        private BuilderImpl() {
        }

        private BuilderImpl(KxDataviewSegmentConfiguration model) {
            this.dbPaths(model.dbPaths);
            this.volumeName(model.volumeName);
            this.onDemand(model.onDemand);
        }

        public final Collection<String> getDbPaths() {
            if (this.dbPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbPaths;
        }

        public final void setDbPaths(Collection<String> dbPaths) {
            this.dbPaths = SegmentConfigurationDbPathListCopier.copy(dbPaths);
        }

        @Override
        public final Builder dbPaths(Collection<String> dbPaths) {
            this.dbPaths = SegmentConfigurationDbPathListCopier.copy(dbPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbPaths(String ... dbPaths) {
            this.dbPaths(Arrays.asList(dbPaths));
            return this;
        }

        public final String getVolumeName() {
            return this.volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final Boolean getOnDemand() {
            return this.onDemand;
        }

        public final void setOnDemand(Boolean onDemand) {
            this.onDemand = onDemand;
        }

        @Override
        public final Builder onDemand(Boolean onDemand) {
            this.onDemand = onDemand;
            return this;
        }

        public KxDataviewSegmentConfiguration build() {
            return new KxDataviewSegmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxDataviewSegmentConfiguration> {
        public Builder dbPaths(Collection<String> var1);

        public Builder dbPaths(String ... var1);

        public Builder volumeName(String var1);

        public Builder onDemand(Boolean var1);
    }
}

