/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse;

public class ListKxChangesetsIterable
implements SdkIterable<ListKxChangesetsResponse> {
    private final FinspaceClient client;
    private final ListKxChangesetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKxChangesetsIterable(FinspaceClient client, ListKxChangesetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKxChangesetsResponseFetcher();
    }

    public Iterator<ListKxChangesetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListKxChangesetsResponseFetcher
    implements SyncPageFetcher<ListKxChangesetsResponse> {
        private ListKxChangesetsResponseFetcher() {
        }

        public boolean hasNextPage(ListKxChangesetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKxChangesetsResponse nextPage(ListKxChangesetsResponse previousPage) {
            if (previousPage == null) {
                return ListKxChangesetsIterable.this.client.listKxChangesets(ListKxChangesetsIterable.this.firstRequest);
            }
            return ListKxChangesetsIterable.this.client.listKxChangesets((ListKxChangesetsRequest)((Object)ListKxChangesetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

