/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KxNAS1Type {
    SSD_1000("SSD_1000"),
    SSD_250("SSD_250"),
    HDD_12("HDD_12"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KxNAS1Type> VALUE_MAP;
    private final String value;

    private KxNAS1Type(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KxNAS1Type fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KxNAS1Type> knownValues() {
        EnumSet<KxNAS1Type> knownValues = EnumSet.allOf(KxNAS1Type.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KxNAS1Type.class, KxNAS1Type::toString);
    }
}

