/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.ChangesetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxChangesetListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxChangesetListEntry> {
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(KxChangesetListEntry.getter(KxChangesetListEntry::changesetId)).setter(KxChangesetListEntry.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(KxChangesetListEntry.getter(KxChangesetListEntry::createdTimestamp)).setter(KxChangesetListEntry.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<Instant> ACTIVE_FROM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("activeFromTimestamp").getter(KxChangesetListEntry.getter(KxChangesetListEntry::activeFromTimestamp)).setter(KxChangesetListEntry.setter(Builder::activeFromTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeFromTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(KxChangesetListEntry.getter(KxChangesetListEntry::lastModifiedTimestamp)).setter(KxChangesetListEntry.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(KxChangesetListEntry.getter(KxChangesetListEntry::statusAsString)).setter(KxChangesetListEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_ID_FIELD, CREATED_TIMESTAMP_FIELD, ACTIVE_FROM_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KxChangesetListEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String changesetId;
    private final Instant createdTimestamp;
    private final Instant activeFromTimestamp;
    private final Instant lastModifiedTimestamp;
    private final String status;

    private KxChangesetListEntry(BuilderImpl builder) {
        this.changesetId = builder.changesetId;
        this.createdTimestamp = builder.createdTimestamp;
        this.activeFromTimestamp = builder.activeFromTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.status = builder.status;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant activeFromTimestamp() {
        return this.activeFromTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final ChangesetStatus status() {
        return ChangesetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeFromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxChangesetListEntry)) {
            return false;
        }
        KxChangesetListEntry other = (KxChangesetListEntry)obj;
        return Objects.equals(this.changesetId(), other.changesetId()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.activeFromTimestamp(), other.activeFromTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KxChangesetListEntry").add("ChangesetId", (Object)this.changesetId()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("ActiveFromTimestamp", (Object)this.activeFromTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "activeFromTimestamp": {
                return Optional.ofNullable(clazz.cast(this.activeFromTimestamp()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("changesetId", CHANGESET_ID_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("activeFromTimestamp", ACTIVE_FROM_TIMESTAMP_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxChangesetListEntry, T> g) {
        return obj -> g.apply((KxChangesetListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changesetId;
        private Instant createdTimestamp;
        private Instant activeFromTimestamp;
        private Instant lastModifiedTimestamp;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(KxChangesetListEntry model) {
            this.changesetId(model.changesetId);
            this.createdTimestamp(model.createdTimestamp);
            this.activeFromTimestamp(model.activeFromTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.status(model.status);
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getActiveFromTimestamp() {
            return this.activeFromTimestamp;
        }

        public final void setActiveFromTimestamp(Instant activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
        }

        @Override
        public final Builder activeFromTimestamp(Instant activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangesetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public KxChangesetListEntry build() {
            return new KxChangesetListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxChangesetListEntry> {
        public Builder changesetId(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder activeFromTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(ChangesetStatus var1);
    }
}

