/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evs.model.EipAssociation;
import software.amazon.awssdk.services.evs.model.EipAssociationListCopier;
import software.amazon.awssdk.services.evs.model.VlanState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vlan> {
    private static final SdkField<Integer> VLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vlanId").getter(Vlan.getter(Vlan::vlanId)).setter(Vlan.setter(Builder::vlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlanId").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cidr").getter(Vlan.getter(Vlan::cidr)).setter(Vlan.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(Vlan.getter(Vlan::availabilityZone)).setter(Vlan.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionName").getter(Vlan.getter(Vlan::functionName)).setter(Vlan.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subnetId").getter(Vlan.getter(Vlan::subnetId)).setter(Vlan.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Vlan.getter(Vlan::createdAt)).setter(Vlan.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(Vlan.getter(Vlan::modifiedAt)).setter(Vlan.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<String> VLAN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vlanState").getter(Vlan.getter(Vlan::vlanStateAsString)).setter(Vlan.setter(Builder::vlanState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlanState").build()}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(Vlan.getter(Vlan::stateDetails)).setter(Vlan.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<List<EipAssociation>> EIP_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eipAssociations").getter(Vlan.getter(Vlan::eipAssociations)).setter(Vlan.setter(Builder::eipAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eipAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EipAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPublic").getter(Vlan.getter(Vlan::isPublic)).setter(Vlan.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()}).build();
    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkAclId").getter(Vlan.getter(Vlan::networkAclId)).setter(Vlan.setter(Builder::networkAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkAclId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VLAN_ID_FIELD, CIDR_FIELD, AVAILABILITY_ZONE_FIELD, FUNCTION_NAME_FIELD, SUBNET_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, VLAN_STATE_FIELD, STATE_DETAILS_FIELD, EIP_ASSOCIATIONS_FIELD, IS_PUBLIC_FIELD, NETWORK_ACL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Vlan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer vlanId;
    private final String cidr;
    private final String availabilityZone;
    private final String functionName;
    private final String subnetId;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String vlanState;
    private final String stateDetails;
    private final List<EipAssociation> eipAssociations;
    private final Boolean isPublic;
    private final String networkAclId;

    private Vlan(BuilderImpl builder) {
        this.vlanId = builder.vlanId;
        this.cidr = builder.cidr;
        this.availabilityZone = builder.availabilityZone;
        this.functionName = builder.functionName;
        this.subnetId = builder.subnetId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.vlanState = builder.vlanState;
        this.stateDetails = builder.stateDetails;
        this.eipAssociations = builder.eipAssociations;
        this.isPublic = builder.isPublic;
        this.networkAclId = builder.networkAclId;
    }

    public final Integer vlanId() {
        return this.vlanId;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final VlanState vlanState() {
        return VlanState.fromValue(this.vlanState);
    }

    public final String vlanStateAsString() {
        return this.vlanState;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final boolean hasEipAssociations() {
        return this.eipAssociations != null && !(this.eipAssociations instanceof SdkAutoConstructList);
    }

    public final List<EipAssociation> eipAssociations() {
        return this.eipAssociations;
    }

    public final Boolean isPublic() {
        return this.isPublic;
    }

    public final String networkAclId() {
        return this.networkAclId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlanStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEipAssociations() ? this.eipAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vlan)) {
            return false;
        }
        Vlan other = (Vlan)obj;
        return Objects.equals(this.vlanId(), other.vlanId()) && Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.vlanStateAsString(), other.vlanStateAsString()) && Objects.equals(this.stateDetails(), other.stateDetails()) && this.hasEipAssociations() == other.hasEipAssociations() && Objects.equals(this.eipAssociations(), other.eipAssociations()) && Objects.equals(this.isPublic(), other.isPublic()) && Objects.equals(this.networkAclId(), other.networkAclId());
    }

    public final String toString() {
        return ToString.builder((String)"Vlan").add("VlanId", (Object)this.vlanId()).add("Cidr", (Object)this.cidr()).add("AvailabilityZone", (Object)this.availabilityZone()).add("FunctionName", (Object)this.functionName()).add("SubnetId", (Object)this.subnetId()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("VlanState", (Object)this.vlanStateAsString()).add("StateDetails", (Object)this.stateDetails()).add("EipAssociations", this.hasEipAssociations() ? this.eipAssociations() : null).add("IsPublic", (Object)this.isPublic()).add("NetworkAclId", (Object)this.networkAclId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vlanId": {
                return Optional.ofNullable(clazz.cast(this.vlanId()));
            }
            case "cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "functionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "subnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "vlanState": {
                return Optional.ofNullable(clazz.cast(this.vlanStateAsString()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "eipAssociations": {
                return Optional.ofNullable(clazz.cast(this.eipAssociations()));
            }
            case "isPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
            case "networkAclId": {
                return Optional.ofNullable(clazz.cast(this.networkAclId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vlanId", VLAN_ID_FIELD);
        map.put("cidr", CIDR_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("functionName", FUNCTION_NAME_FIELD);
        map.put("subnetId", SUBNET_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("vlanState", VLAN_STATE_FIELD);
        map.put("stateDetails", STATE_DETAILS_FIELD);
        map.put("eipAssociations", EIP_ASSOCIATIONS_FIELD);
        map.put("isPublic", IS_PUBLIC_FIELD);
        map.put("networkAclId", NETWORK_ACL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Vlan, T> g) {
        return obj -> g.apply((Vlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer vlanId;
        private String cidr;
        private String availabilityZone;
        private String functionName;
        private String subnetId;
        private Instant createdAt;
        private Instant modifiedAt;
        private String vlanState;
        private String stateDetails;
        private List<EipAssociation> eipAssociations = DefaultSdkAutoConstructList.getInstance();
        private Boolean isPublic;
        private String networkAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(Vlan model) {
            this.vlanId(model.vlanId);
            this.cidr(model.cidr);
            this.availabilityZone(model.availabilityZone);
            this.functionName(model.functionName);
            this.subnetId(model.subnetId);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.vlanState(model.vlanState);
            this.stateDetails(model.stateDetails);
            this.eipAssociations(model.eipAssociations);
            this.isPublic(model.isPublic);
            this.networkAclId(model.networkAclId);
        }

        public final Integer getVlanId() {
            return this.vlanId;
        }

        public final void setVlanId(Integer vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public final Builder vlanId(Integer vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getVlanState() {
            return this.vlanState;
        }

        public final void setVlanState(String vlanState) {
            this.vlanState = vlanState;
        }

        @Override
        public final Builder vlanState(String vlanState) {
            this.vlanState = vlanState;
            return this;
        }

        @Override
        public final Builder vlanState(VlanState vlanState) {
            this.vlanState(vlanState == null ? null : vlanState.toString());
            return this;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final List<EipAssociation.Builder> getEipAssociations() {
            List<EipAssociation.Builder> result = EipAssociationListCopier.copyToBuilder(this.eipAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEipAssociations(Collection<EipAssociation.BuilderImpl> eipAssociations) {
            this.eipAssociations = EipAssociationListCopier.copyFromBuilder(eipAssociations);
        }

        @Override
        public final Builder eipAssociations(Collection<EipAssociation> eipAssociations) {
            this.eipAssociations = EipAssociationListCopier.copy(eipAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eipAssociations(EipAssociation ... eipAssociations) {
            this.eipAssociations(Arrays.asList(eipAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eipAssociations(Consumer<EipAssociation.Builder> ... eipAssociations) {
            this.eipAssociations(Stream.of(eipAssociations).map(c -> (EipAssociation)((EipAssociation.Builder)EipAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public Vlan build() {
            return new Vlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vlan> {
        public Builder vlanId(Integer var1);

        public Builder cidr(String var1);

        public Builder availabilityZone(String var1);

        public Builder functionName(String var1);

        public Builder subnetId(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder vlanState(String var1);

        public Builder vlanState(VlanState var1);

        public Builder stateDetails(String var1);

        public Builder eipAssociations(Collection<EipAssociation> var1);

        public Builder eipAssociations(EipAssociation ... var1);

        public Builder eipAssociations(Consumer<EipAssociation.Builder> ... var1);

        public Builder isPublic(Boolean var1);

        public Builder networkAclId(String var1);
    }
}

