/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination;
import software.amazon.awssdk.services.evidently.model.S3Destination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectDataDelivery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectDataDelivery> {
    private static final SdkField<CloudWatchLogsDestination> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(ProjectDataDelivery.getter(ProjectDataDelivery::cloudWatchLogs)).setter(ProjectDataDelivery.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Destination").getter(ProjectDataDelivery.getter(ProjectDataDelivery::s3Destination)).setter(ProjectDataDelivery.setter(Builder::s3Destination)).constructor(S3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, S3_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectDataDelivery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsDestination cloudWatchLogs;
    private final S3Destination s3Destination;

    private ProjectDataDelivery(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.s3Destination = builder.s3Destination;
    }

    public final CloudWatchLogsDestination cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final S3Destination s3Destination() {
        return this.s3Destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDataDelivery)) {
            return false;
        }
        ProjectDataDelivery other = (ProjectDataDelivery)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectDataDelivery").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("S3Destination", (Object)this.s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "s3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("s3Destination", S3_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectDataDelivery, T> g) {
        return obj -> g.apply((ProjectDataDelivery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsDestination cloudWatchLogs;
        private S3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDataDelivery model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.s3Destination(model.s3Destination);
        }

        public final CloudWatchLogsDestination.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsDestination.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsDestination cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final S3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public ProjectDataDelivery build() {
            return new ProjectDataDelivery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectDataDelivery> {
        public Builder cloudWatchLogs(CloudWatchLogsDestination var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsDestination.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsDestination)((CloudWatchLogsDestination.Builder)CloudWatchLogsDestination.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder s3Destination(S3Destination var1);

        default public Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return this.s3Destination((S3Destination)((S3Destination.Builder)S3Destination.builder().applyMutation(s3Destination)).build());
        }
    }
}

