/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDefinition> {
    private static final SdkField<String> ENTITY_ID_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityIdKey").getter(MetricDefinition.getter(MetricDefinition::entityIdKey)).setter(MetricDefinition.setter(Builder::entityIdKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityIdKey").build()}).build();
    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventPattern").getter(MetricDefinition.getter(MetricDefinition::eventPattern)).setter(MetricDefinition.setter(Builder::eventPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPattern").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MetricDefinition.getter(MetricDefinition::name)).setter(MetricDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> UNIT_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unitLabel").getter(MetricDefinition.getter(MetricDefinition::unitLabel)).setter(MetricDefinition.setter(Builder::unitLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unitLabel").build()}).build();
    private static final SdkField<String> VALUE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("valueKey").getter(MetricDefinition.getter(MetricDefinition::valueKey)).setter(MetricDefinition.setter(Builder::valueKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_KEY_FIELD, EVENT_PATTERN_FIELD, NAME_FIELD, UNIT_LABEL_FIELD, VALUE_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entityIdKey;
    private final String eventPattern;
    private final String name;
    private final String unitLabel;
    private final String valueKey;

    private MetricDefinition(BuilderImpl builder) {
        this.entityIdKey = builder.entityIdKey;
        this.eventPattern = builder.eventPattern;
        this.name = builder.name;
        this.unitLabel = builder.unitLabel;
        this.valueKey = builder.valueKey;
    }

    public final String entityIdKey() {
        return this.entityIdKey;
    }

    public final String eventPattern() {
        return this.eventPattern;
    }

    public final String name() {
        return this.name;
    }

    public final String unitLabel() {
        return this.unitLabel;
    }

    public final String valueKey() {
        return this.valueKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition)obj;
        return Objects.equals(this.entityIdKey(), other.entityIdKey()) && Objects.equals(this.eventPattern(), other.eventPattern()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.unitLabel(), other.unitLabel()) && Objects.equals(this.valueKey(), other.valueKey());
    }

    public final String toString() {
        return ToString.builder((String)"MetricDefinition").add("EntityIdKey", (Object)this.entityIdKey()).add("EventPattern", (Object)this.eventPattern()).add("Name", (Object)this.name()).add("UnitLabel", (Object)this.unitLabel()).add("ValueKey", (Object)this.valueKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityIdKey": {
                return Optional.ofNullable(clazz.cast(this.entityIdKey()));
            }
            case "eventPattern": {
                return Optional.ofNullable(clazz.cast(this.eventPattern()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "unitLabel": {
                return Optional.ofNullable(clazz.cast(this.unitLabel()));
            }
            case "valueKey": {
                return Optional.ofNullable(clazz.cast(this.valueKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("entityIdKey", ENTITY_ID_KEY_FIELD);
        map.put("eventPattern", EVENT_PATTERN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("unitLabel", UNIT_LABEL_FIELD);
        map.put("valueKey", VALUE_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDefinition, T> g) {
        return obj -> g.apply((MetricDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityIdKey;
        private String eventPattern;
        private String name;
        private String unitLabel;
        private String valueKey;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDefinition model) {
            this.entityIdKey(model.entityIdKey);
            this.eventPattern(model.eventPattern);
            this.name(model.name);
            this.unitLabel(model.unitLabel);
            this.valueKey(model.valueKey);
        }

        public final String getEntityIdKey() {
            return this.entityIdKey;
        }

        public final void setEntityIdKey(String entityIdKey) {
            this.entityIdKey = entityIdKey;
        }

        @Override
        public final Builder entityIdKey(String entityIdKey) {
            this.entityIdKey = entityIdKey;
            return this;
        }

        public final String getEventPattern() {
            return this.eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUnitLabel() {
            return this.unitLabel;
        }

        public final void setUnitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
        }

        @Override
        public final Builder unitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
            return this;
        }

        public final String getValueKey() {
            return this.valueKey;
        }

        public final void setValueKey(String valueKey) {
            this.valueKey = valueKey;
        }

        @Override
        public final Builder valueKey(String valueKey) {
            this.valueKey = valueKey;
            return this;
        }

        public MetricDefinition build() {
            return new MetricDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDefinition> {
        public Builder entityIdKey(String var1);

        public Builder eventPattern(String var1);

        public Builder name(String var1);

        public Builder unitLabel(String var1);

        public Builder valueKey(String var1);
    }
}

