/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeauthorizeConnectionResponse extends EventBridgeResponse implements
        ToCopyableBuilder<DeauthorizeConnectionResponse.Builder, DeauthorizeConnectionResponse> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(DeauthorizeConnectionResponse::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionState").getter(getter(DeauthorizeConnectionResponse::connectionStateAsString))
            .setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DeauthorizeConnectionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DeauthorizeConnectionResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> LAST_AUTHORIZED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAuthorizedTime").getter(getter(DeauthorizeConnectionResponse::lastAuthorizedTime))
            .setter(setter(Builder::lastAuthorizedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthorizedTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            CONNECTION_STATE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_AUTHORIZED_TIME_FIELD));

    private final String connectionArn;

    private final String connectionState;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final Instant lastAuthorizedTime;

    private DeauthorizeConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionArn = builder.connectionArn;
        this.connectionState = builder.connectionState;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastAuthorizedTime = builder.lastAuthorizedTime;
    }

    /**
     * <p>
     * The ARN of the connection that authorization was removed from.
     * </p>
     * 
     * @return The ARN of the connection that authorization was removed from.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The state of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection.
     * @see ConnectionState
     */
    public final ConnectionState connectionState() {
        return ConnectionState.fromValue(connectionState);
    }

    /**
     * <p>
     * The state of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection.
     * @see ConnectionState
     */
    public final String connectionStateAsString() {
        return connectionState;
    }

    /**
     * <p>
     * A time stamp for the time that the connection was created.
     * </p>
     * 
     * @return A time stamp for the time that the connection was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A time stamp for the time that the connection was last updated.
     * </p>
     * 
     * @return A time stamp for the time that the connection was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A time stamp for the time that the connection was last authorized.
     * </p>
     * 
     * @return A time stamp for the time that the connection was last authorized.
     */
    public final Instant lastAuthorizedTime() {
        return lastAuthorizedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastAuthorizedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeauthorizeConnectionResponse)) {
            return false;
        }
        DeauthorizeConnectionResponse other = (DeauthorizeConnectionResponse) obj;
        return Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(connectionStateAsString(), other.connectionStateAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastAuthorizedTime(), other.lastAuthorizedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeauthorizeConnectionResponse").add("ConnectionArn", connectionArn())
                .add("ConnectionState", connectionStateAsString()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("LastAuthorizedTime", lastAuthorizedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "ConnectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastAuthorizedTime":
            return Optional.ofNullable(clazz.cast(lastAuthorizedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeauthorizeConnectionResponse, T> g) {
        return obj -> g.apply((DeauthorizeConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeauthorizeConnectionResponse> {
        /**
         * <p>
         * The ARN of the connection that authorization was removed from.
         * </p>
         * 
         * @param connectionArn
         *        The ARN of the connection that authorization was removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The state of the connection.
         * </p>
         * 
         * @param connectionState
         *        The state of the connection.
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * <p>
         * The state of the connection.
         * </p>
         * 
         * @param connectionState
         *        The state of the connection.
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(ConnectionState connectionState);

        /**
         * <p>
         * A time stamp for the time that the connection was created.
         * </p>
         * 
         * @param creationTime
         *        A time stamp for the time that the connection was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A time stamp for the time that the connection was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        A time stamp for the time that the connection was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A time stamp for the time that the connection was last authorized.
         * </p>
         * 
         * @param lastAuthorizedTime
         *        A time stamp for the time that the connection was last authorized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAuthorizedTime(Instant lastAuthorizedTime);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private String connectionArn;

        private String connectionState;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private Instant lastAuthorizedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeauthorizeConnectionResponse model) {
            super(model);
            connectionArn(model.connectionArn);
            connectionState(model.connectionState);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            lastAuthorizedTime(model.lastAuthorizedTime);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getConnectionState() {
            return connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getLastAuthorizedTime() {
            return lastAuthorizedTime;
        }

        public final void setLastAuthorizedTime(Instant lastAuthorizedTime) {
            this.lastAuthorizedTime = lastAuthorizedTime;
        }

        @Override
        public final Builder lastAuthorizedTime(Instant lastAuthorizedTime) {
            this.lastAuthorizedTime = lastAuthorizedTime;
            return this;
        }

        @Override
        public DeauthorizeConnectionResponse build() {
            return new DeauthorizeConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
