/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and
 * 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target
 * is an Batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchArrayProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchArrayProperties.Builder, BatchArrayProperties> {
    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Size")
            .getter(getter(BatchArrayProperties::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer size;

    private BatchArrayProperties(BuilderImpl builder) {
        this.size = builder.size;
    }

    /**
     * <p>
     * The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
     * </p>
     * 
     * @return The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
     */
    public final Integer size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchArrayProperties)) {
            return false;
        }
        BatchArrayProperties other = (BatchArrayProperties) obj;
        return Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchArrayProperties").add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchArrayProperties, T> g) {
        return obj -> g.apply((BatchArrayProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchArrayProperties> {
        /**
         * <p>
         * The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
         * </p>
         * 
         * @param size
         *        The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);
    }

    static final class BuilderImpl implements Builder {
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchArrayProperties model) {
            size(model.size);
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        @Override
        public BatchArrayProperties build() {
            return new BatchArrayProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
