/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProviderServiceRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, GetProviderServiceRequest> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(GetProviderServiceRequest.getter(GetProviderServiceRequest::providerName)).setter(GetProviderServiceRequest.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("providerName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceName").getter(GetProviderServiceRequest.getter(GetProviderServiceRequest::providerServiceName)).setter(GetProviderServiceRequest.setter(Builder::providerServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("providerServiceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD, PROVIDER_SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProviderServiceRequest.memberNameToFieldInitializer();
    private final String providerName;
    private final String providerServiceName;

    private GetProviderServiceRequest(BuilderImpl builder) {
        super(builder);
        this.providerName = builder.providerName;
        this.providerServiceName = builder.providerServiceName;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final String providerServiceName() {
        return this.providerServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProviderServiceRequest)) {
            return false;
        }
        GetProviderServiceRequest other = (GetProviderServiceRequest)((Object)obj);
        return Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.providerServiceName(), other.providerServiceName());
    }

    public final String toString() {
        return ToString.builder((String)"GetProviderServiceRequest").add("ProviderName", (Object)this.providerName()).add("ProviderServiceName", (Object)this.providerServiceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "providerServiceName": {
                return Optional.ofNullable(clazz.cast(this.providerServiceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("providerServiceName", PROVIDER_SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProviderServiceRequest, T> g) {
        return obj -> g.apply((GetProviderServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private String providerName;
        private String providerServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProviderServiceRequest model) {
            super(model);
            this.providerName(model.providerName);
            this.providerServiceName(model.providerServiceName);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderServiceName() {
            return this.providerServiceName;
        }

        public final void setProviderServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
        }

        @Override
        public final Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProviderServiceRequest build() {
            return new GetProviderServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProviderServiceRequest> {
        public Builder providerName(String var1);

        public Builder providerServiceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

