/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdMappingJobRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, GetIdMappingJobRequest> {
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(GetIdMappingJobRequest.getter(GetIdMappingJobRequest::workflowName)).setter(GetIdMappingJobRequest.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(GetIdMappingJobRequest.getter(GetIdMappingJobRequest::jobId)).setter(GetIdMappingJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_NAME_FIELD, JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIdMappingJobRequest.memberNameToFieldInitializer();
    private final String workflowName;
    private final String jobId;

    private GetIdMappingJobRequest(BuilderImpl builder) {
        super(builder);
        this.workflowName = builder.workflowName;
        this.jobId = builder.jobId;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdMappingJobRequest)) {
            return false;
        }
        GetIdMappingJobRequest other = (GetIdMappingJobRequest)((Object)obj);
        return Objects.equals(this.workflowName(), other.workflowName()) && Objects.equals(this.jobId(), other.jobId());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdMappingJobRequest").add("WorkflowName", (Object)this.workflowName()).add("JobId", (Object)this.jobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdMappingJobRequest, T> g) {
        return obj -> g.apply((GetIdMappingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private String workflowName;
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdMappingJobRequest model) {
            super(model);
            this.workflowName(model.workflowName);
            this.jobId(model.jobId);
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdMappingJobRequest build() {
            return new GetIdMappingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdMappingJobRequest> {
        public Builder workflowName(String var1);

        public Builder jobId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

