/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse;
import software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary;

public class ListSchemaMappingsIterable
implements SdkIterable<ListSchemaMappingsResponse> {
    private final EntityResolutionClient client;
    private final ListSchemaMappingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSchemaMappingsIterable(EntityResolutionClient client, ListSchemaMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSchemaMappingsResponseFetcher();
    }

    public Iterator<ListSchemaMappingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SchemaMappingSummary> schemaList() {
        Function<ListSchemaMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemaList() != null) {
                return response.schemaList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSchemaMappingsResponseFetcher
    implements SyncPageFetcher<ListSchemaMappingsResponse> {
        private ListSchemaMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemaMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSchemaMappingsResponse nextPage(ListSchemaMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListSchemaMappingsIterable.this.client.listSchemaMappings(ListSchemaMappingsIterable.this.firstRequest);
            }
            return ListSchemaMappingsIterable.this.client.listSchemaMappings((ListSchemaMappingsRequest)((Object)ListSchemaMappingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

