/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.IdMappingIncrementalRunConfig;
import software.amazon.awssdk.services.entityresolution.model.IdMappingTechniques;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSourceConfigCopier;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSourceConfigCopier;
import software.amazon.awssdk.services.entityresolution.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdMappingWorkflowResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, GetIdMappingWorkflowResponse> {
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::workflowName)).setter(GetIdMappingWorkflowResponse.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowName").build()}).build();
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowArn").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::workflowArn)).setter(GetIdMappingWorkflowResponse.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::description)).setter(GetIdMappingWorkflowResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<IdMappingWorkflowInputSource>> INPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputSourceConfig").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::inputSourceConfig)).setter(GetIdMappingWorkflowResponse.setter(Builder::inputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdMappingWorkflowInputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IdMappingWorkflowOutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputSourceConfig").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::outputSourceConfig)).setter(GetIdMappingWorkflowResponse.setter(Builder::outputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdMappingWorkflowOutputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IdMappingTechniques> ID_MAPPING_TECHNIQUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("idMappingTechniques").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::idMappingTechniques)).setter(GetIdMappingWorkflowResponse.setter(Builder::idMappingTechniques)).constructor(IdMappingTechniques::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingTechniques").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::createdAt)).setter(GetIdMappingWorkflowResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::updatedAt)).setter(GetIdMappingWorkflowResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<IdMappingIncrementalRunConfig> INCREMENTAL_RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("incrementalRunConfig").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::incrementalRunConfig)).setter(GetIdMappingWorkflowResponse.setter(Builder::incrementalRunConfig)).constructor(IdMappingIncrementalRunConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalRunConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::roleArn)).setter(GetIdMappingWorkflowResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetIdMappingWorkflowResponse.getter(GetIdMappingWorkflowResponse::tags)).setter(GetIdMappingWorkflowResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_NAME_FIELD, WORKFLOW_ARN_FIELD, DESCRIPTION_FIELD, INPUT_SOURCE_CONFIG_FIELD, OUTPUT_SOURCE_CONFIG_FIELD, ID_MAPPING_TECHNIQUES_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, INCREMENTAL_RUN_CONFIG_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIdMappingWorkflowResponse.memberNameToFieldInitializer();
    private final String workflowName;
    private final String workflowArn;
    private final String description;
    private final List<IdMappingWorkflowInputSource> inputSourceConfig;
    private final List<IdMappingWorkflowOutputSource> outputSourceConfig;
    private final IdMappingTechniques idMappingTechniques;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final IdMappingIncrementalRunConfig incrementalRunConfig;
    private final String roleArn;
    private final Map<String, String> tags;

    private GetIdMappingWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflowName = builder.workflowName;
        this.workflowArn = builder.workflowArn;
        this.description = builder.description;
        this.inputSourceConfig = builder.inputSourceConfig;
        this.outputSourceConfig = builder.outputSourceConfig;
        this.idMappingTechniques = builder.idMappingTechniques;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.incrementalRunConfig = builder.incrementalRunConfig;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasInputSourceConfig() {
        return this.inputSourceConfig != null && !(this.inputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<IdMappingWorkflowInputSource> inputSourceConfig() {
        return this.inputSourceConfig;
    }

    public final boolean hasOutputSourceConfig() {
        return this.outputSourceConfig != null && !(this.outputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<IdMappingWorkflowOutputSource> outputSourceConfig() {
        return this.outputSourceConfig;
    }

    public final IdMappingTechniques idMappingTechniques() {
        return this.idMappingTechniques;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final IdMappingIncrementalRunConfig incrementalRunConfig() {
        return this.incrementalRunConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSourceConfig() ? this.inputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSourceConfig() ? this.outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idMappingTechniques());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.incrementalRunConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdMappingWorkflowResponse)) {
            return false;
        }
        GetIdMappingWorkflowResponse other = (GetIdMappingWorkflowResponse)((Object)obj);
        return Objects.equals(this.workflowName(), other.workflowName()) && Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.description(), other.description()) && this.hasInputSourceConfig() == other.hasInputSourceConfig() && Objects.equals(this.inputSourceConfig(), other.inputSourceConfig()) && this.hasOutputSourceConfig() == other.hasOutputSourceConfig() && Objects.equals(this.outputSourceConfig(), other.outputSourceConfig()) && Objects.equals(this.idMappingTechniques(), other.idMappingTechniques()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.incrementalRunConfig(), other.incrementalRunConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdMappingWorkflowResponse").add("WorkflowName", (Object)this.workflowName()).add("WorkflowArn", (Object)this.workflowArn()).add("Description", (Object)this.description()).add("InputSourceConfig", this.hasInputSourceConfig() ? this.inputSourceConfig() : null).add("OutputSourceConfig", this.hasOutputSourceConfig() ? this.outputSourceConfig() : null).add("IdMappingTechniques", (Object)this.idMappingTechniques()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("IncrementalRunConfig", (Object)this.incrementalRunConfig()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
            case "workflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.inputSourceConfig()));
            }
            case "outputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.outputSourceConfig()));
            }
            case "idMappingTechniques": {
                return Optional.ofNullable(clazz.cast(this.idMappingTechniques()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "incrementalRunConfig": {
                return Optional.ofNullable(clazz.cast(this.incrementalRunConfig()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        map.put("workflowArn", WORKFLOW_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputSourceConfig", INPUT_SOURCE_CONFIG_FIELD);
        map.put("outputSourceConfig", OUTPUT_SOURCE_CONFIG_FIELD);
        map.put("idMappingTechniques", ID_MAPPING_TECHNIQUES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("incrementalRunConfig", INCREMENTAL_RUN_CONFIG_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdMappingWorkflowResponse, T> g) {
        return obj -> g.apply((GetIdMappingWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private String workflowName;
        private String workflowArn;
        private String description;
        private List<IdMappingWorkflowInputSource> inputSourceConfig = DefaultSdkAutoConstructList.getInstance();
        private List<IdMappingWorkflowOutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();
        private IdMappingTechniques idMappingTechniques;
        private Instant createdAt;
        private Instant updatedAt;
        private IdMappingIncrementalRunConfig incrementalRunConfig;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdMappingWorkflowResponse model) {
            super(model);
            this.workflowName(model.workflowName);
            this.workflowArn(model.workflowArn);
            this.description(model.description);
            this.inputSourceConfig(model.inputSourceConfig);
            this.outputSourceConfig(model.outputSourceConfig);
            this.idMappingTechniques(model.idMappingTechniques);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.incrementalRunConfig(model.incrementalRunConfig);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IdMappingWorkflowInputSource.Builder> getInputSourceConfig() {
            List<IdMappingWorkflowInputSource.Builder> result = IdMappingWorkflowInputSourceConfigCopier.copyToBuilder(this.inputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSourceConfig(Collection<IdMappingWorkflowInputSource.BuilderImpl> inputSourceConfig) {
            this.inputSourceConfig = IdMappingWorkflowInputSourceConfigCopier.copyFromBuilder(inputSourceConfig);
        }

        @Override
        public final Builder inputSourceConfig(Collection<IdMappingWorkflowInputSource> inputSourceConfig) {
            this.inputSourceConfig = IdMappingWorkflowInputSourceConfigCopier.copy(inputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(IdMappingWorkflowInputSource ... inputSourceConfig) {
            this.inputSourceConfig(Arrays.asList(inputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(Consumer<IdMappingWorkflowInputSource.Builder> ... inputSourceConfig) {
            this.inputSourceConfig(Stream.of(inputSourceConfig).map(c -> (IdMappingWorkflowInputSource)((IdMappingWorkflowInputSource.Builder)IdMappingWorkflowInputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IdMappingWorkflowOutputSource.Builder> getOutputSourceConfig() {
            List<IdMappingWorkflowOutputSource.Builder> result = IdMappingWorkflowOutputSourceConfigCopier.copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<IdMappingWorkflowOutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = IdMappingWorkflowOutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<IdMappingWorkflowOutputSource> outputSourceConfig) {
            this.outputSourceConfig = IdMappingWorkflowOutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(IdMappingWorkflowOutputSource ... outputSourceConfig) {
            this.outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<IdMappingWorkflowOutputSource.Builder> ... outputSourceConfig) {
            this.outputSourceConfig(Stream.of(outputSourceConfig).map(c -> (IdMappingWorkflowOutputSource)((IdMappingWorkflowOutputSource.Builder)IdMappingWorkflowOutputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IdMappingTechniques.Builder getIdMappingTechniques() {
            return this.idMappingTechniques != null ? this.idMappingTechniques.toBuilder() : null;
        }

        public final void setIdMappingTechniques(IdMappingTechniques.BuilderImpl idMappingTechniques) {
            this.idMappingTechniques = idMappingTechniques != null ? idMappingTechniques.build() : null;
        }

        @Override
        public final Builder idMappingTechniques(IdMappingTechniques idMappingTechniques) {
            this.idMappingTechniques = idMappingTechniques;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final IdMappingIncrementalRunConfig.Builder getIncrementalRunConfig() {
            return this.incrementalRunConfig != null ? this.incrementalRunConfig.toBuilder() : null;
        }

        public final void setIncrementalRunConfig(IdMappingIncrementalRunConfig.BuilderImpl incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig != null ? incrementalRunConfig.build() : null;
        }

        @Override
        public final Builder incrementalRunConfig(IdMappingIncrementalRunConfig incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetIdMappingWorkflowResponse build() {
            return new GetIdMappingWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdMappingWorkflowResponse> {
        public Builder workflowName(String var1);

        public Builder workflowArn(String var1);

        public Builder description(String var1);

        public Builder inputSourceConfig(Collection<IdMappingWorkflowInputSource> var1);

        public Builder inputSourceConfig(IdMappingWorkflowInputSource ... var1);

        public Builder inputSourceConfig(Consumer<IdMappingWorkflowInputSource.Builder> ... var1);

        public Builder outputSourceConfig(Collection<IdMappingWorkflowOutputSource> var1);

        public Builder outputSourceConfig(IdMappingWorkflowOutputSource ... var1);

        public Builder outputSourceConfig(Consumer<IdMappingWorkflowOutputSource.Builder> ... var1);

        public Builder idMappingTechniques(IdMappingTechniques var1);

        default public Builder idMappingTechniques(Consumer<IdMappingTechniques.Builder> idMappingTechniques) {
            return this.idMappingTechniques((IdMappingTechniques)((IdMappingTechniques.Builder)IdMappingTechniques.builder().applyMutation(idMappingTechniques)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder incrementalRunConfig(IdMappingIncrementalRunConfig var1);

        default public Builder incrementalRunConfig(Consumer<IdMappingIncrementalRunConfig.Builder> incrementalRunConfig) {
            return this.incrementalRunConfig((IdMappingIncrementalRunConfig)((IdMappingIncrementalRunConfig.Builder)IdMappingIncrementalRunConfig.builder().applyMutation(incrementalRunConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

