/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.JobSummary;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse;

public class ListIdMappingJobsIterable
implements SdkIterable<ListIdMappingJobsResponse> {
    private final EntityResolutionClient client;
    private final ListIdMappingJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdMappingJobsIterable(EntityResolutionClient client, ListIdMappingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIdMappingJobsResponseFetcher();
    }

    public Iterator<ListIdMappingJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobSummary> jobs() {
        Function<ListIdMappingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdMappingJobsResponseFetcher
    implements SyncPageFetcher<ListIdMappingJobsResponse> {
        private ListIdMappingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdMappingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdMappingJobsResponse nextPage(ListIdMappingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListIdMappingJobsIterable.this.client.listIdMappingJobs(ListIdMappingJobsIterable.this.firstRequest);
            }
            return ListIdMappingJobsIterable.this.client.listIdMappingJobs((ListIdMappingJobsRequest)((Object)ListIdMappingJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

