/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowListCopier;
import software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMatchingWorkflowsResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, ListMatchingWorkflowsResponse> {
    private static final SdkField<List<MatchingWorkflowSummary>> WORKFLOW_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflowSummaries").getter(ListMatchingWorkflowsResponse.getter(ListMatchingWorkflowsResponse::workflowSummaries)).setter(ListMatchingWorkflowsResponse.setter(Builder::workflowSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchingWorkflowSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMatchingWorkflowsResponse.getter(ListMatchingWorkflowsResponse::nextToken)).setter(ListMatchingWorkflowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMatchingWorkflowsResponse.memberNameToFieldInitializer();
    private final List<MatchingWorkflowSummary> workflowSummaries;
    private final String nextToken;

    private ListMatchingWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.workflowSummaries = builder.workflowSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkflowSummaries() {
        return this.workflowSummaries != null && !(this.workflowSummaries instanceof SdkAutoConstructList);
    }

    public final List<MatchingWorkflowSummary> workflowSummaries() {
        return this.workflowSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflowSummaries() ? this.workflowSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMatchingWorkflowsResponse)) {
            return false;
        }
        ListMatchingWorkflowsResponse other = (ListMatchingWorkflowsResponse)((Object)obj);
        return this.hasWorkflowSummaries() == other.hasWorkflowSummaries() && Objects.equals(this.workflowSummaries(), other.workflowSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMatchingWorkflowsResponse").add("WorkflowSummaries", this.hasWorkflowSummaries() ? this.workflowSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowSummaries": {
                return Optional.ofNullable(clazz.cast(this.workflowSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowSummaries", WORKFLOW_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMatchingWorkflowsResponse, T> g) {
        return obj -> g.apply((ListMatchingWorkflowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private List<MatchingWorkflowSummary> workflowSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMatchingWorkflowsResponse model) {
            super(model);
            this.workflowSummaries(model.workflowSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<MatchingWorkflowSummary.Builder> getWorkflowSummaries() {
            List<MatchingWorkflowSummary.Builder> result = MatchingWorkflowListCopier.copyToBuilder(this.workflowSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowSummaries(Collection<MatchingWorkflowSummary.BuilderImpl> workflowSummaries) {
            this.workflowSummaries = MatchingWorkflowListCopier.copyFromBuilder(workflowSummaries);
        }

        @Override
        public final Builder workflowSummaries(Collection<MatchingWorkflowSummary> workflowSummaries) {
            this.workflowSummaries = MatchingWorkflowListCopier.copy(workflowSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowSummaries(MatchingWorkflowSummary ... workflowSummaries) {
            this.workflowSummaries(Arrays.asList(workflowSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowSummaries(Consumer<MatchingWorkflowSummary.Builder> ... workflowSummaries) {
            this.workflowSummaries(Stream.of(workflowSummaries).map(c -> (MatchingWorkflowSummary)((MatchingWorkflowSummary.Builder)MatchingWorkflowSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMatchingWorkflowsResponse build() {
            return new ListMatchingWorkflowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMatchingWorkflowsResponse> {
        public Builder workflowSummaries(Collection<MatchingWorkflowSummary> var1);

        public Builder workflowSummaries(MatchingWorkflowSummary ... var1);

        public Builder workflowSummaries(Consumer<MatchingWorkflowSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

