/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowSummary;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse;

public class ListIdMappingWorkflowsIterable
implements SdkIterable<ListIdMappingWorkflowsResponse> {
    private final EntityResolutionClient client;
    private final ListIdMappingWorkflowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdMappingWorkflowsIterable(EntityResolutionClient client, ListIdMappingWorkflowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIdMappingWorkflowsResponseFetcher();
    }

    public Iterator<ListIdMappingWorkflowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IdMappingWorkflowSummary> workflowSummaries() {
        Function<ListIdMappingWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowSummaries() != null) {
                return response.workflowSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdMappingWorkflowsResponseFetcher
    implements SyncPageFetcher<ListIdMappingWorkflowsResponse> {
        private ListIdMappingWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdMappingWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdMappingWorkflowsResponse nextPage(ListIdMappingWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListIdMappingWorkflowsIterable.this.client.listIdMappingWorkflows(ListIdMappingWorkflowsIterable.this.firstRequest);
            }
            return ListIdMappingWorkflowsIterable.this.client.listIdMappingWorkflows((ListIdMappingWorkflowsRequest)((Object)ListIdMappingWorkflowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

