/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configurations for the Hive job driver.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hive implements SdkPojo, Serializable, ToCopyableBuilder<Hive.Builder, Hive> {
    private static final SdkField<String> QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("query")
            .getter(getter(Hive::query)).setter(setter(Builder::query))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()).build();

    private static final SdkField<String> INIT_QUERY_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initQueryFile").getter(getter(Hive::initQueryFile)).setter(setter(Builder::initQueryFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initQueryFile").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameters").getter(getter(Hive::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD,
            INIT_QUERY_FILE_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String query;

    private final String initQueryFile;

    private final String parameters;

    private Hive(BuilderImpl builder) {
        this.query = builder.query;
        this.initQueryFile = builder.initQueryFile;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The query for the Hive job run.
     * </p>
     * 
     * @return The query for the Hive job run.
     */
    public final String query() {
        return query;
    }

    /**
     * <p>
     * The query file for the Hive job run.
     * </p>
     * 
     * @return The query file for the Hive job run.
     */
    public final String initQueryFile() {
        return initQueryFile;
    }

    /**
     * <p>
     * The parameters for the Hive job run.
     * </p>
     * 
     * @return The parameters for the Hive job run.
     */
    public final String parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(query());
        hashCode = 31 * hashCode + Objects.hashCode(initQueryFile());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hive)) {
            return false;
        }
        Hive other = (Hive) obj;
        return Objects.equals(query(), other.query()) && Objects.equals(initQueryFile(), other.initQueryFile())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Hive").add("Query", query() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InitQueryFile", initQueryFile() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "query":
            return Optional.ofNullable(clazz.cast(query()));
        case "initQueryFile":
            return Optional.ofNullable(clazz.cast(initQueryFile()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hive, T> g) {
        return obj -> g.apply((Hive) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hive> {
        /**
         * <p>
         * The query for the Hive job run.
         * </p>
         * 
         * @param query
         *        The query for the Hive job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);

        /**
         * <p>
         * The query file for the Hive job run.
         * </p>
         * 
         * @param initQueryFile
         *        The query file for the Hive job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initQueryFile(String initQueryFile);

        /**
         * <p>
         * The parameters for the Hive job run.
         * </p>
         * 
         * @param parameters
         *        The parameters for the Hive job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);
    }

    static final class BuilderImpl implements Builder {
        private String query;

        private String initQueryFile;

        private String parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Hive model) {
            query(model.query);
            initQueryFile(model.initQueryFile);
            parameters(model.parameters);
        }

        public final String getQuery() {
            return query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final String getInitQueryFile() {
            return initQueryFile;
        }

        public final void setInitQueryFile(String initQueryFile) {
            this.initQueryFile = initQueryFile;
        }

        @Override
        public final Builder initQueryFile(String initQueryFile) {
            this.initQueryFile = initQueryFile;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Hive build() {
            return new Hive(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
