/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application. EMR Serverless uses applications to run jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Application implements SdkPojo, Serializable, ToCopyableBuilder<Application.Builder, Application> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(Application::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Application::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Application::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(Application::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Application::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(Application::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateDetails").getter(getter(Application::stateDetails)).setter(setter(Builder::stateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()).build();

    private static final SdkField<Map<String, InitialCapacityConfig>> INITIAL_CAPACITY_FIELD = SdkField
            .<Map<String, InitialCapacityConfig>> builder(MarshallingType.MAP)
            .memberName("initialCapacity")
            .getter(getter(Application::initialCapacity))
            .setter(setter(Builder::initialCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialCapacity").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<InitialCapacityConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InitialCapacityConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MaximumAllowedResources> MAXIMUM_CAPACITY_FIELD = SdkField
            .<MaximumAllowedResources> builder(MarshallingType.SDK_POJO).memberName("maximumCapacity")
            .getter(getter(Application::maximumCapacity)).setter(setter(Builder::maximumCapacity))
            .constructor(MaximumAllowedResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumCapacity").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Application::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Application::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Application::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AutoStartConfig> AUTO_START_CONFIGURATION_FIELD = SdkField
            .<AutoStartConfig> builder(MarshallingType.SDK_POJO).memberName("autoStartConfiguration")
            .getter(getter(Application::autoStartConfiguration)).setter(setter(Builder::autoStartConfiguration))
            .constructor(AutoStartConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStartConfiguration").build())
            .build();

    private static final SdkField<AutoStopConfig> AUTO_STOP_CONFIGURATION_FIELD = SdkField
            .<AutoStopConfig> builder(MarshallingType.SDK_POJO).memberName("autoStopConfiguration")
            .getter(getter(Application::autoStopConfiguration)).setter(setter(Builder::autoStopConfiguration))
            .constructor(AutoStopConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStopConfiguration").build())
            .build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(Application::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(Application::architectureAsString)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<ImageConfiguration> IMAGE_CONFIGURATION_FIELD = SdkField
            .<ImageConfiguration> builder(MarshallingType.SDK_POJO).memberName("imageConfiguration")
            .getter(getter(Application::imageConfiguration)).setter(setter(Builder::imageConfiguration))
            .constructor(ImageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageConfiguration").build())
            .build();

    private static final SdkField<Map<String, WorkerTypeSpecification>> WORKER_TYPE_SPECIFICATIONS_FIELD = SdkField
            .<Map<String, WorkerTypeSpecification>> builder(MarshallingType.MAP)
            .memberName("workerTypeSpecifications")
            .getter(getter(Application::workerTypeSpecifications))
            .setter(setter(Builder::workerTypeSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerTypeSpecifications").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<WorkerTypeSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerTypeSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            NAME_FIELD, ARN_FIELD, RELEASE_LABEL_FIELD, TYPE_FIELD, STATE_FIELD, STATE_DETAILS_FIELD, INITIAL_CAPACITY_FIELD,
            MAXIMUM_CAPACITY_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD, AUTO_START_CONFIGURATION_FIELD,
            AUTO_STOP_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, ARCHITECTURE_FIELD, IMAGE_CONFIGURATION_FIELD,
            WORKER_TYPE_SPECIFICATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String name;

    private final String arn;

    private final String releaseLabel;

    private final String type;

    private final String state;

    private final String stateDetails;

    private final Map<String, InitialCapacityConfig> initialCapacity;

    private final MaximumAllowedResources maximumCapacity;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Map<String, String> tags;

    private final AutoStartConfig autoStartConfiguration;

    private final AutoStopConfig autoStopConfiguration;

    private final NetworkConfiguration networkConfiguration;

    private final String architecture;

    private final ImageConfiguration imageConfiguration;

    private final Map<String, WorkerTypeSpecification> workerTypeSpecifications;

    private Application(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.releaseLabel = builder.releaseLabel;
        this.type = builder.type;
        this.state = builder.state;
        this.stateDetails = builder.stateDetails;
        this.initialCapacity = builder.initialCapacity;
        this.maximumCapacity = builder.maximumCapacity;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
        this.autoStartConfiguration = builder.autoStartConfiguration;
        this.autoStopConfiguration = builder.autoStopConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.architecture = builder.architecture;
        this.imageConfiguration = builder.imageConfiguration;
        this.workerTypeSpecifications = builder.workerTypeSpecifications;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the application.
     * </p>
     * 
     * @return The ARN of the application.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The EMR release associated with the application.
     * </p>
     * 
     * @return The EMR release associated with the application.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * The type of application, such as Spark or Hive.
     * </p>
     * 
     * @return The type of application, such as Spark or Hive.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The state of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the application.
     * @see ApplicationState
     */
    public final ApplicationState state() {
        return ApplicationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the application.
     * @see ApplicationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The state details of the application.
     * </p>
     * 
     * @return The state details of the application.
     */
    public final String stateDetails() {
        return stateDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the InitialCapacity property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInitialCapacity() {
        return initialCapacity != null && !(initialCapacity instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The initial capacity of the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitialCapacity} method.
     * </p>
     * 
     * @return The initial capacity of the application.
     */
    public final Map<String, InitialCapacityConfig> initialCapacity() {
        return initialCapacity;
    }

    /**
     * <p>
     * The maximum capacity of the application. This is cumulative across all workers at any given point in time during
     * the lifespan of the application is created. No new resources will be created once any one of the defined limits
     * is hit.
     * </p>
     * 
     * @return The maximum capacity of the application. This is cumulative across all workers at any given point in time
     *         during the lifespan of the application is created. No new resources will be created once any one of the
     *         defined limits is hit.
     */
    public final MaximumAllowedResources maximumCapacity() {
        return maximumCapacity;
    }

    /**
     * <p>
     * The date and time when the application run was created.
     * </p>
     * 
     * @return The date and time when the application run was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the application run was last updated.
     * </p>
     * 
     * @return The date and time when the application run was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the application.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for an application to automatically start on job submission.
     * </p>
     * 
     * @return The configuration for an application to automatically start on job submission.
     */
    public final AutoStartConfig autoStartConfiguration() {
        return autoStartConfiguration;
    }

    /**
     * <p>
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     * </p>
     * 
     * @return The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    public final AutoStopConfig autoStopConfiguration() {
        return autoStopConfiguration;
    }

    /**
     * <p>
     * The network configuration for customer VPC connectivity for the application.
     * </p>
     * 
     * @return The network configuration for customer VPC connectivity for the application.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The CPU architecture of an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The CPU architecture of an application.
     * @see Architecture
     */
    public final Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The CPU architecture of an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The CPU architecture of an application.
     * @see Architecture
     */
    public final String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The image configuration applied to all worker types.
     * </p>
     * 
     * @return The image configuration applied to all worker types.
     */
    public final ImageConfiguration imageConfiguration() {
        return imageConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkerTypeSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkerTypeSpecifications() {
        return workerTypeSpecifications != null && !(workerTypeSpecifications instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The specification applied to each worker type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkerTypeSpecifications} method.
     * </p>
     * 
     * @return The specification applied to each worker type.
     */
    public final Map<String, WorkerTypeSpecification> workerTypeSpecifications() {
        return workerTypeSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasInitialCapacity() ? initialCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maximumCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoStartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoStopConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkerTypeSpecifications() ? workerTypeSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(name(), other.name())
                && Objects.equals(arn(), other.arn()) && Objects.equals(releaseLabel(), other.releaseLabel())
                && Objects.equals(type(), other.type()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateDetails(), other.stateDetails()) && hasInitialCapacity() == other.hasInitialCapacity()
                && Objects.equals(initialCapacity(), other.initialCapacity())
                && Objects.equals(maximumCapacity(), other.maximumCapacity()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(autoStartConfiguration(), other.autoStartConfiguration())
                && Objects.equals(autoStopConfiguration(), other.autoStopConfiguration())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(imageConfiguration(), other.imageConfiguration())
                && hasWorkerTypeSpecifications() == other.hasWorkerTypeSpecifications()
                && Objects.equals(workerTypeSpecifications(), other.workerTypeSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Application").add("ApplicationId", applicationId()).add("Name", name()).add("Arn", arn())
                .add("ReleaseLabel", releaseLabel()).add("Type", type()).add("State", stateAsString())
                .add("StateDetails", stateDetails()).add("InitialCapacity", hasInitialCapacity() ? initialCapacity() : null)
                .add("MaximumCapacity", maximumCapacity()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("Tags", hasTags() ? tags() : null).add("AutoStartConfiguration", autoStartConfiguration())
                .add("AutoStopConfiguration", autoStopConfiguration()).add("NetworkConfiguration", networkConfiguration())
                .add("Architecture", architectureAsString()).add("ImageConfiguration", imageConfiguration())
                .add("WorkerTypeSpecifications", hasWorkerTypeSpecifications() ? workerTypeSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "stateDetails":
            return Optional.ofNullable(clazz.cast(stateDetails()));
        case "initialCapacity":
            return Optional.ofNullable(clazz.cast(initialCapacity()));
        case "maximumCapacity":
            return Optional.ofNullable(clazz.cast(maximumCapacity()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "autoStartConfiguration":
            return Optional.ofNullable(clazz.cast(autoStartConfiguration()));
        case "autoStopConfiguration":
            return Optional.ofNullable(clazz.cast(autoStopConfiguration()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "imageConfiguration":
            return Optional.ofNullable(clazz.cast(imageConfiguration()));
        case "workerTypeSpecifications":
            return Optional.ofNullable(clazz.cast(workerTypeSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Application> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the application.
         * </p>
         * 
         * @param arn
         *        The ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The EMR release associated with the application.
         * </p>
         * 
         * @param releaseLabel
         *        The EMR release associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The type of application, such as Spark or Hive.
         * </p>
         * 
         * @param type
         *        The type of application, such as Spark or Hive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The state of the application.
         * </p>
         * 
         * @param state
         *        The state of the application.
         * @see ApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the application.
         * </p>
         * 
         * @param state
         *        The state of the application.
         * @see ApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationState
         */
        Builder state(ApplicationState state);

        /**
         * <p>
         * The state details of the application.
         * </p>
         * 
         * @param stateDetails
         *        The state details of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateDetails(String stateDetails);

        /**
         * <p>
         * The initial capacity of the application.
         * </p>
         * 
         * @param initialCapacity
         *        The initial capacity of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialCapacity(Map<String, InitialCapacityConfig> initialCapacity);

        /**
         * <p>
         * The maximum capacity of the application. This is cumulative across all workers at any given point in time
         * during the lifespan of the application is created. No new resources will be created once any one of the
         * defined limits is hit.
         * </p>
         * 
         * @param maximumCapacity
         *        The maximum capacity of the application. This is cumulative across all workers at any given point in
         *        time during the lifespan of the application is created. No new resources will be created once any one
         *        of the defined limits is hit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumCapacity(MaximumAllowedResources maximumCapacity);

        /**
         * <p>
         * The maximum capacity of the application. This is cumulative across all workers at any given point in time
         * during the lifespan of the application is created. No new resources will be created once any one of the
         * defined limits is hit.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaximumAllowedResources.Builder} avoiding
         * the need to create one manually via {@link MaximumAllowedResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaximumAllowedResources.Builder#build()} is called immediately
         * and its result is passed to {@link #maximumCapacity(MaximumAllowedResources)}.
         * 
         * @param maximumCapacity
         *        a consumer that will call methods on {@link MaximumAllowedResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumCapacity(MaximumAllowedResources)
         */
        default Builder maximumCapacity(Consumer<MaximumAllowedResources.Builder> maximumCapacity) {
            return maximumCapacity(MaximumAllowedResources.builder().applyMutation(maximumCapacity).build());
        }

        /**
         * <p>
         * The date and time when the application run was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the application run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the application run was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time when the application run was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The tags assigned to the application.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration for an application to automatically start on job submission.
         * </p>
         * 
         * @param autoStartConfiguration
         *        The configuration for an application to automatically start on job submission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoStartConfiguration(AutoStartConfig autoStartConfiguration);

        /**
         * <p>
         * The configuration for an application to automatically start on job submission.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoStartConfig.Builder} avoiding the
         * need to create one manually via {@link AutoStartConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoStartConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoStartConfiguration(AutoStartConfig)}.
         * 
         * @param autoStartConfiguration
         *        a consumer that will call methods on {@link AutoStartConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoStartConfiguration(AutoStartConfig)
         */
        default Builder autoStartConfiguration(Consumer<AutoStartConfig.Builder> autoStartConfiguration) {
            return autoStartConfiguration(AutoStartConfig.builder().applyMutation(autoStartConfiguration).build());
        }

        /**
         * <p>
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * </p>
         * 
         * @param autoStopConfiguration
         *        The configuration for an application to automatically stop after a certain amount of time being idle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoStopConfiguration(AutoStopConfig autoStopConfiguration);

        /**
         * <p>
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoStopConfig.Builder} avoiding the need
         * to create one manually via {@link AutoStopConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoStopConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoStopConfiguration(AutoStopConfig)}.
         * 
         * @param autoStopConfiguration
         *        a consumer that will call methods on {@link AutoStopConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoStopConfiguration(AutoStopConfig)
         */
        default Builder autoStopConfiguration(Consumer<AutoStopConfig.Builder> autoStopConfiguration) {
            return autoStopConfiguration(AutoStopConfig.builder().applyMutation(autoStopConfiguration).build());
        }

        /**
         * <p>
         * The network configuration for customer VPC connectivity for the application.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for customer VPC connectivity for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for customer VPC connectivity for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The CPU architecture of an application.
         * </p>
         * 
         * @param architecture
         *        The CPU architecture of an application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The CPU architecture of an application.
         * </p>
         * 
         * @param architecture
         *        The CPU architecture of an application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * The image configuration applied to all worker types.
         * </p>
         * 
         * @param imageConfiguration
         *        The image configuration applied to all worker types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageConfiguration(ImageConfiguration imageConfiguration);

        /**
         * <p>
         * The image configuration applied to all worker types.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageConfiguration.Builder} avoiding the
         * need to create one manually via {@link ImageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #imageConfiguration(ImageConfiguration)}.
         * 
         * @param imageConfiguration
         *        a consumer that will call methods on {@link ImageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageConfiguration(ImageConfiguration)
         */
        default Builder imageConfiguration(Consumer<ImageConfiguration.Builder> imageConfiguration) {
            return imageConfiguration(ImageConfiguration.builder().applyMutation(imageConfiguration).build());
        }

        /**
         * <p>
         * The specification applied to each worker type.
         * </p>
         * 
         * @param workerTypeSpecifications
         *        The specification applied to each worker type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerTypeSpecifications(Map<String, WorkerTypeSpecification> workerTypeSpecifications);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String name;

        private String arn;

        private String releaseLabel;

        private String type;

        private String state;

        private String stateDetails;

        private Map<String, InitialCapacityConfig> initialCapacity = DefaultSdkAutoConstructMap.getInstance();

        private MaximumAllowedResources maximumCapacity;

        private Instant createdAt;

        private Instant updatedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private AutoStartConfig autoStartConfiguration;

        private AutoStopConfig autoStopConfiguration;

        private NetworkConfiguration networkConfiguration;

        private String architecture;

        private ImageConfiguration imageConfiguration;

        private Map<String, WorkerTypeSpecification> workerTypeSpecifications = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            applicationId(model.applicationId);
            name(model.name);
            arn(model.arn);
            releaseLabel(model.releaseLabel);
            type(model.type);
            state(model.state);
            stateDetails(model.stateDetails);
            initialCapacity(model.initialCapacity);
            maximumCapacity(model.maximumCapacity);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            tags(model.tags);
            autoStartConfiguration(model.autoStartConfiguration);
            autoStopConfiguration(model.autoStopConfiguration);
            networkConfiguration(model.networkConfiguration);
            architecture(model.architecture);
            imageConfiguration(model.imageConfiguration);
            workerTypeSpecifications(model.workerTypeSpecifications);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ApplicationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateDetails() {
            return stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final Map<String, InitialCapacityConfig.Builder> getInitialCapacity() {
            Map<String, InitialCapacityConfig.Builder> result = InitialCapacityConfigMapCopier
                    .copyToBuilder(this.initialCapacity);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInitialCapacity(Map<String, InitialCapacityConfig.BuilderImpl> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copyFromBuilder(initialCapacity);
        }

        @Override
        public final Builder initialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copy(initialCapacity);
            return this;
        }

        public final MaximumAllowedResources.Builder getMaximumCapacity() {
            return maximumCapacity != null ? maximumCapacity.toBuilder() : null;
        }

        public final void setMaximumCapacity(MaximumAllowedResources.BuilderImpl maximumCapacity) {
            this.maximumCapacity = maximumCapacity != null ? maximumCapacity.build() : null;
        }

        @Override
        public final Builder maximumCapacity(MaximumAllowedResources maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final AutoStartConfig.Builder getAutoStartConfiguration() {
            return autoStartConfiguration != null ? autoStartConfiguration.toBuilder() : null;
        }

        public final void setAutoStartConfiguration(AutoStartConfig.BuilderImpl autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration != null ? autoStartConfiguration.build() : null;
        }

        @Override
        public final Builder autoStartConfiguration(AutoStartConfig autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        public final AutoStopConfig.Builder getAutoStopConfiguration() {
            return autoStopConfiguration != null ? autoStopConfiguration.toBuilder() : null;
        }

        public final void setAutoStopConfiguration(AutoStopConfig.BuilderImpl autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration != null ? autoStopConfiguration.build() : null;
        }

        @Override
        public final Builder autoStopConfiguration(AutoStopConfig autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final ImageConfiguration.Builder getImageConfiguration() {
            return imageConfiguration != null ? imageConfiguration.toBuilder() : null;
        }

        public final void setImageConfiguration(ImageConfiguration.BuilderImpl imageConfiguration) {
            this.imageConfiguration = imageConfiguration != null ? imageConfiguration.build() : null;
        }

        @Override
        public final Builder imageConfiguration(ImageConfiguration imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        public final Map<String, WorkerTypeSpecification.Builder> getWorkerTypeSpecifications() {
            Map<String, WorkerTypeSpecification.Builder> result = WorkerTypeSpecificationMapCopier
                    .copyToBuilder(this.workerTypeSpecifications);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setWorkerTypeSpecifications(Map<String, WorkerTypeSpecification.BuilderImpl> workerTypeSpecifications) {
            this.workerTypeSpecifications = WorkerTypeSpecificationMapCopier.copyFromBuilder(workerTypeSpecifications);
        }

        @Override
        public final Builder workerTypeSpecifications(Map<String, WorkerTypeSpecification> workerTypeSpecifications) {
            this.workerTypeSpecifications = WorkerTypeSpecificationMapCopier.copy(workerTypeSpecifications);
            return this;
        }

        @Override
        public Application build() {
            return new Application(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
