/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.EncryptionConfiguration;
import software.amazon.awssdk.services.emrcontainers.model.LakeFormationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizationConfiguration> {
    private static final SdkField<LakeFormationConfiguration> LAKE_FORMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lakeFormationConfiguration").getter(AuthorizationConfiguration.getter(AuthorizationConfiguration::lakeFormationConfiguration)).setter(AuthorizationConfiguration.setter(Builder::lakeFormationConfiguration)).constructor(LakeFormationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakeFormationConfiguration").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(AuthorizationConfiguration.getter(AuthorizationConfiguration::encryptionConfiguration)).setter(AuthorizationConfiguration.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAKE_FORMATION_CONFIGURATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthorizationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LakeFormationConfiguration lakeFormationConfiguration;
    private final EncryptionConfiguration encryptionConfiguration;

    private AuthorizationConfiguration(BuilderImpl builder) {
        this.lakeFormationConfiguration = builder.lakeFormationConfiguration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final LakeFormationConfiguration lakeFormationConfiguration() {
        return this.lakeFormationConfiguration;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lakeFormationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationConfiguration)) {
            return false;
        }
        AuthorizationConfiguration other = (AuthorizationConfiguration)obj;
        return Objects.equals(this.lakeFormationConfiguration(), other.lakeFormationConfiguration()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizationConfiguration").add("LakeFormationConfiguration", (Object)this.lakeFormationConfiguration()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lakeFormationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lakeFormationConfiguration()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lakeFormationConfiguration", LAKE_FORMATION_CONFIGURATION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationConfiguration, T> g) {
        return obj -> g.apply((AuthorizationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LakeFormationConfiguration lakeFormationConfiguration;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationConfiguration model) {
            this.lakeFormationConfiguration(model.lakeFormationConfiguration);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final LakeFormationConfiguration.Builder getLakeFormationConfiguration() {
            return this.lakeFormationConfiguration != null ? this.lakeFormationConfiguration.toBuilder() : null;
        }

        public final void setLakeFormationConfiguration(LakeFormationConfiguration.BuilderImpl lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration != null ? lakeFormationConfiguration.build() : null;
        }

        @Override
        public final Builder lakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public AuthorizationConfiguration build() {
            return new AuthorizationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizationConfiguration> {
        public Builder lakeFormationConfiguration(LakeFormationConfiguration var1);

        default public Builder lakeFormationConfiguration(Consumer<LakeFormationConfiguration.Builder> lakeFormationConfiguration) {
            return this.lakeFormationConfiguration((LakeFormationConfiguration)((LakeFormationConfiguration.Builder)LakeFormationConfiguration.builder().applyMutation(lakeFormationConfiguration)).build());
        }

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }
    }
}

