/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.Credentials;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetManagedEndpointSessionCredentialsResponse
extends EmrContainersResponse
implements ToCopyableBuilder<Builder, GetManagedEndpointSessionCredentialsResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetManagedEndpointSessionCredentialsResponse.getter(GetManagedEndpointSessionCredentialsResponse::id)).setter(GetManagedEndpointSessionCredentialsResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credentials").getter(GetManagedEndpointSessionCredentialsResponse.getter(GetManagedEndpointSessionCredentialsResponse::credentials)).setter(GetManagedEndpointSessionCredentialsResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(GetManagedEndpointSessionCredentialsResponse.getter(GetManagedEndpointSessionCredentialsResponse::expiresAt)).setter(GetManagedEndpointSessionCredentialsResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CREDENTIALS_FIELD, EXPIRES_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetManagedEndpointSessionCredentialsResponse.memberNameToFieldInitializer();
    private final String id;
    private final Credentials credentials;
    private final Instant expiresAt;

    private GetManagedEndpointSessionCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.credentials = builder.credentials;
        this.expiresAt = builder.expiresAt;
    }

    public final String id() {
        return this.id;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedEndpointSessionCredentialsResponse)) {
            return false;
        }
        GetManagedEndpointSessionCredentialsResponse other = (GetManagedEndpointSessionCredentialsResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.expiresAt(), other.expiresAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetManagedEndpointSessionCredentialsResponse").add("Id", (Object)this.id()).add("Credentials", (Object)this.credentials()).add("ExpiresAt", (Object)this.expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("credentials", CREDENTIALS_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedEndpointSessionCredentialsResponse, T> g) {
        return obj -> g.apply((GetManagedEndpointSessionCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersResponse.BuilderImpl
    implements Builder {
        private String id;
        private Credentials credentials;
        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedEndpointSessionCredentialsResponse model) {
            super(model);
            this.id(model.id);
            this.credentials(model.credentials);
            this.expiresAt(model.expiresAt);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public GetManagedEndpointSessionCredentialsResponse build() {
            return new GetManagedEndpointSessionCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrContainersResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetManagedEndpointSessionCredentialsResponse> {
        public Builder id(String var1);

        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder expiresAt(Instant var1);
    }
}

