/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetVisibleToAllUsersRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, SetVisibleToAllUsersRequest> {
    private static final SdkField<List<String>> JOB_FLOW_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobFlowIds").getter(SetVisibleToAllUsersRequest.getter(SetVisibleToAllUsersRequest::jobFlowIds)).setter(SetVisibleToAllUsersRequest.setter(Builder::jobFlowIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> VISIBLE_TO_ALL_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VisibleToAllUsers").getter(SetVisibleToAllUsersRequest.getter(SetVisibleToAllUsersRequest::visibleToAllUsers)).setter(SetVisibleToAllUsersRequest.setter(Builder::visibleToAllUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibleToAllUsers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_IDS_FIELD, VISIBLE_TO_ALL_USERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetVisibleToAllUsersRequest.memberNameToFieldInitializer();
    private final List<String> jobFlowIds;
    private final Boolean visibleToAllUsers;

    private SetVisibleToAllUsersRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowIds = builder.jobFlowIds;
        this.visibleToAllUsers = builder.visibleToAllUsers;
    }

    public final boolean hasJobFlowIds() {
        return this.jobFlowIds != null && !(this.jobFlowIds instanceof SdkAutoConstructList);
    }

    public final List<String> jobFlowIds() {
        return this.jobFlowIds;
    }

    public final Boolean visibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobFlowIds() ? this.jobFlowIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibleToAllUsers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetVisibleToAllUsersRequest)) {
            return false;
        }
        SetVisibleToAllUsersRequest other = (SetVisibleToAllUsersRequest)((Object)obj);
        return this.hasJobFlowIds() == other.hasJobFlowIds() && Objects.equals(this.jobFlowIds(), other.jobFlowIds()) && Objects.equals(this.visibleToAllUsers(), other.visibleToAllUsers());
    }

    public final String toString() {
        return ToString.builder((String)"SetVisibleToAllUsersRequest").add("JobFlowIds", this.hasJobFlowIds() ? this.jobFlowIds() : null).add("VisibleToAllUsers", (Object)this.visibleToAllUsers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowIds": {
                return Optional.ofNullable(clazz.cast(this.jobFlowIds()));
            }
            case "VisibleToAllUsers": {
                return Optional.ofNullable(clazz.cast(this.visibleToAllUsers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobFlowIds", JOB_FLOW_IDS_FIELD);
        map.put("VisibleToAllUsers", VISIBLE_TO_ALL_USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetVisibleToAllUsersRequest, T> g) {
        return obj -> g.apply((SetVisibleToAllUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private List<String> jobFlowIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean visibleToAllUsers;

        private BuilderImpl() {
        }

        private BuilderImpl(SetVisibleToAllUsersRequest model) {
            super(model);
            this.jobFlowIds(model.jobFlowIds);
            this.visibleToAllUsers(model.visibleToAllUsers);
        }

        public final Collection<String> getJobFlowIds() {
            if (this.jobFlowIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobFlowIds;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String ... jobFlowIds) {
            this.jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetVisibleToAllUsersRequest build() {
            return new SetVisibleToAllUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetVisibleToAllUsersRequest> {
        public Builder jobFlowIds(Collection<String> var1);

        public Builder jobFlowIds(String ... var1);

        public Builder visibleToAllUsers(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

