/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.internal.UserAgentUtils;
import software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest;
import software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse;
import software.amazon.awssdk.services.emr.model.NotebookExecutionSummary;

public class ListNotebookExecutionsPublisher
implements SdkPublisher<ListNotebookExecutionsResponse> {
    private final EmrAsyncClient client;
    private final ListNotebookExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotebookExecutionsPublisher(EmrAsyncClient client, ListNotebookExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotebookExecutionsPublisher(EmrAsyncClient client, ListNotebookExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotebookExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotebookExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotebookExecutionSummary> notebookExecutions() {
        Function<ListNotebookExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notebookExecutions() != null) {
                return response.notebookExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotebookExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotebookExecutionsResponseFetcher
    implements AsyncPageFetcher<ListNotebookExecutionsResponse> {
        private ListNotebookExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotebookExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListNotebookExecutionsResponse> nextPage(ListNotebookExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListNotebookExecutionsPublisher.this.client.listNotebookExecutions(ListNotebookExecutionsPublisher.this.firstRequest);
            }
            return ListNotebookExecutionsPublisher.this.client.listNotebookExecutions((ListNotebookExecutionsRequest)((Object)ListNotebookExecutionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

