/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScaleDownBehavior {
    TERMINATE_AT_INSTANCE_HOUR("TERMINATE_AT_INSTANCE_HOUR"),
    TERMINATE_AT_TASK_COMPLETION("TERMINATE_AT_TASK_COMPLETION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScaleDownBehavior> VALUE_MAP;
    private final String value;

    private ScaleDownBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScaleDownBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScaleDownBehavior> knownValues() {
        EnumSet<ScaleDownBehavior> knownValues = EnumSet.allOf(ScaleDownBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScaleDownBehavior.class, ScaleDownBehavior::toString);
    }
}

