/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProfilerType {
    SHS("SHS"),
    TEZUI("TEZUI"),
    YTS("YTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProfilerType> VALUE_MAP;
    private final String value;

    private ProfilerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProfilerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProfilerType> knownValues() {
        EnumSet<ProfilerType> knownValues = EnumSet.allOf(ProfilerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProfilerType.class, ProfilerType::toString);
    }
}

