/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.NotebookExecutionSummary;
import software.amazon.awssdk.services.emr.model.NotebookExecutionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotebookExecutionsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListNotebookExecutionsResponse> {
    private static final SdkField<List<NotebookExecutionSummary>> NOTEBOOK_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotebookExecutions").getter(ListNotebookExecutionsResponse.getter(ListNotebookExecutionsResponse::notebookExecutions)).setter(ListNotebookExecutionsResponse.setter(Builder::notebookExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotebookExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListNotebookExecutionsResponse.getter(ListNotebookExecutionsResponse::marker)).setter(ListNotebookExecutionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_EXECUTIONS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotebookExecutionsResponse.memberNameToFieldInitializer();
    private final List<NotebookExecutionSummary> notebookExecutions;
    private final String marker;

    private ListNotebookExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.notebookExecutions = builder.notebookExecutions;
        this.marker = builder.marker;
    }

    public final boolean hasNotebookExecutions() {
        return this.notebookExecutions != null && !(this.notebookExecutions instanceof SdkAutoConstructList);
    }

    public final List<NotebookExecutionSummary> notebookExecutions() {
        return this.notebookExecutions;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotebookExecutions() ? this.notebookExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookExecutionsResponse)) {
            return false;
        }
        ListNotebookExecutionsResponse other = (ListNotebookExecutionsResponse)((Object)obj);
        return this.hasNotebookExecutions() == other.hasNotebookExecutions() && Objects.equals(this.notebookExecutions(), other.notebookExecutions()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotebookExecutionsResponse").add("NotebookExecutions", this.hasNotebookExecutions() ? this.notebookExecutions() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookExecutions": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotebookExecutions", NOTEBOOK_EXECUTIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookExecutionsResponse, T> g) {
        return obj -> g.apply((ListNotebookExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<NotebookExecutionSummary> notebookExecutions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookExecutionsResponse model) {
            super(model);
            this.notebookExecutions(model.notebookExecutions);
            this.marker(model.marker);
        }

        public final List<NotebookExecutionSummary.Builder> getNotebookExecutions() {
            List<NotebookExecutionSummary.Builder> result = NotebookExecutionSummaryListCopier.copyToBuilder(this.notebookExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotebookExecutions(Collection<NotebookExecutionSummary.BuilderImpl> notebookExecutions) {
            this.notebookExecutions = NotebookExecutionSummaryListCopier.copyFromBuilder(notebookExecutions);
        }

        @Override
        public final Builder notebookExecutions(Collection<NotebookExecutionSummary> notebookExecutions) {
            this.notebookExecutions = NotebookExecutionSummaryListCopier.copy(notebookExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookExecutions(NotebookExecutionSummary ... notebookExecutions) {
            this.notebookExecutions(Arrays.asList(notebookExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookExecutions(Consumer<NotebookExecutionSummary.Builder> ... notebookExecutions) {
            this.notebookExecutions(Stream.of(notebookExecutions).map(c -> (NotebookExecutionSummary)((NotebookExecutionSummary.Builder)NotebookExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListNotebookExecutionsResponse build() {
            return new ListNotebookExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotebookExecutionsResponse> {
        public Builder notebookExecutions(Collection<NotebookExecutionSummary> var1);

        public Builder notebookExecutions(NotebookExecutionSummary ... var1);

        public Builder notebookExecutions(Consumer<NotebookExecutionSummary.Builder> ... var1);

        public Builder marker(String var1);
    }
}

