/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.OnClusterAppUIType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOnClusterAppUiPresignedUrlRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, GetOnClusterAppUiPresignedUrlRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(GetOnClusterAppUiPresignedUrlRequest.getter(GetOnClusterAppUiPresignedUrlRequest::clusterId)).setter(GetOnClusterAppUiPresignedUrlRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> ON_CLUSTER_APP_UI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnClusterAppUIType").getter(GetOnClusterAppUiPresignedUrlRequest.getter(GetOnClusterAppUiPresignedUrlRequest::onClusterAppUITypeAsString)).setter(GetOnClusterAppUiPresignedUrlRequest.setter(Builder::onClusterAppUIType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnClusterAppUIType").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(GetOnClusterAppUiPresignedUrlRequest.getter(GetOnClusterAppUiPresignedUrlRequest::applicationId)).setter(GetOnClusterAppUiPresignedUrlRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetOnClusterAppUiPresignedUrlRequest.getter(GetOnClusterAppUiPresignedUrlRequest::dryRun)).setter(GetOnClusterAppUiPresignedUrlRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(GetOnClusterAppUiPresignedUrlRequest.getter(GetOnClusterAppUiPresignedUrlRequest::executionRoleArn)).setter(GetOnClusterAppUiPresignedUrlRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, ON_CLUSTER_APP_UI_TYPE_FIELD, APPLICATION_ID_FIELD, DRY_RUN_FIELD, EXECUTION_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOnClusterAppUiPresignedUrlRequest.memberNameToFieldInitializer();
    private final String clusterId;
    private final String onClusterAppUIType;
    private final String applicationId;
    private final Boolean dryRun;
    private final String executionRoleArn;

    private GetOnClusterAppUiPresignedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.onClusterAppUIType = builder.onClusterAppUIType;
        this.applicationId = builder.applicationId;
        this.dryRun = builder.dryRun;
        this.executionRoleArn = builder.executionRoleArn;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final OnClusterAppUIType onClusterAppUIType() {
        return OnClusterAppUIType.fromValue(this.onClusterAppUIType);
    }

    public final String onClusterAppUITypeAsString() {
        return this.onClusterAppUIType;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.onClusterAppUITypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOnClusterAppUiPresignedUrlRequest)) {
            return false;
        }
        GetOnClusterAppUiPresignedUrlRequest other = (GetOnClusterAppUiPresignedUrlRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.onClusterAppUITypeAsString(), other.onClusterAppUITypeAsString()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetOnClusterAppUiPresignedUrlRequest").add("ClusterId", (Object)this.clusterId()).add("OnClusterAppUIType", (Object)this.onClusterAppUITypeAsString()).add("ApplicationId", (Object)this.applicationId()).add("DryRun", (Object)this.dryRun()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "OnClusterAppUIType": {
                return Optional.ofNullable(clazz.cast(this.onClusterAppUITypeAsString()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("OnClusterAppUIType", ON_CLUSTER_APP_UI_TYPE_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOnClusterAppUiPresignedUrlRequest, T> g) {
        return obj -> g.apply((GetOnClusterAppUiPresignedUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String onClusterAppUIType;
        private String applicationId;
        private Boolean dryRun;
        private String executionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOnClusterAppUiPresignedUrlRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.onClusterAppUIType(model.onClusterAppUIType);
            this.applicationId(model.applicationId);
            this.dryRun(model.dryRun);
            this.executionRoleArn(model.executionRoleArn);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getOnClusterAppUIType() {
            return this.onClusterAppUIType;
        }

        public final void setOnClusterAppUIType(String onClusterAppUIType) {
            this.onClusterAppUIType = onClusterAppUIType;
        }

        @Override
        public final Builder onClusterAppUIType(String onClusterAppUIType) {
            this.onClusterAppUIType = onClusterAppUIType;
            return this;
        }

        @Override
        public final Builder onClusterAppUIType(OnClusterAppUIType onClusterAppUIType) {
            this.onClusterAppUIType(onClusterAppUIType == null ? null : onClusterAppUIType.toString());
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOnClusterAppUiPresignedUrlRequest build() {
            return new GetOnClusterAppUiPresignedUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOnClusterAppUiPresignedUrlRequest> {
        public Builder clusterId(String var1);

        public Builder onClusterAppUIType(String var1);

        public Builder onClusterAppUIType(OnClusterAppUIType var1);

        public Builder applicationId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder executionRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

