/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalingStrategy {
    DEFAULT("DEFAULT"),
    ADVANCED("ADVANCED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalingStrategy> VALUE_MAP;
    private final String value;

    private ScalingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalingStrategy> knownValues() {
        EnumSet<ScalingStrategy> knownValues = EnumSet.allOf(ScalingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalingStrategy.class, ScalingStrategy::toString);
    }
}

