/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSupportedInstanceTypesResponse extends EmrResponse implements
        ToCopyableBuilder<ListSupportedInstanceTypesResponse.Builder, ListSupportedInstanceTypesResponse> {
    private static final SdkField<List<SupportedInstanceType>> SUPPORTED_INSTANCE_TYPES_FIELD = SdkField
            .<List<SupportedInstanceType>> builder(MarshallingType.LIST)
            .memberName("SupportedInstanceTypes")
            .getter(getter(ListSupportedInstanceTypesResponse::supportedInstanceTypes))
            .setter(setter(Builder::supportedInstanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupportedInstanceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedInstanceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListSupportedInstanceTypesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUPPORTED_INSTANCE_TYPES_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SupportedInstanceType> supportedInstanceTypes;

    private final String marker;

    private ListSupportedInstanceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.supportedInstanceTypes = builder.supportedInstanceTypes;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedInstanceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedInstanceTypes() {
        return supportedInstanceTypes != null && !(supportedInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of instance types that the release specified in
     * <code>ListSupportedInstanceTypesInput$ReleaseLabel</code> supports, filtered by Amazon Web Services Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedInstanceTypes} method.
     * </p>
     * 
     * @return The list of instance types that the release specified in
     *         <code>ListSupportedInstanceTypesInput$ReleaseLabel</code> supports, filtered by Amazon Web Services
     *         Region.
     */
    public final List<SupportedInstanceType> supportedInstanceTypes() {
        return supportedInstanceTypes;
    }

    /**
     * <p>
     * The pagination token that marks the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that marks the next set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedInstanceTypes() ? supportedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupportedInstanceTypesResponse)) {
            return false;
        }
        ListSupportedInstanceTypesResponse other = (ListSupportedInstanceTypesResponse) obj;
        return hasSupportedInstanceTypes() == other.hasSupportedInstanceTypes()
                && Objects.equals(supportedInstanceTypes(), other.supportedInstanceTypes())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSupportedInstanceTypesResponse")
                .add("SupportedInstanceTypes", hasSupportedInstanceTypes() ? supportedInstanceTypes() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SupportedInstanceTypes":
            return Optional.ofNullable(clazz.cast(supportedInstanceTypes()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SupportedInstanceTypes", SUPPORTED_INSTANCE_TYPES_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSupportedInstanceTypesResponse, T> g) {
        return obj -> g.apply((ListSupportedInstanceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSupportedInstanceTypesResponse> {
        /**
         * <p>
         * The list of instance types that the release specified in
         * <code>ListSupportedInstanceTypesInput$ReleaseLabel</code> supports, filtered by Amazon Web Services Region.
         * </p>
         * 
         * @param supportedInstanceTypes
         *        The list of instance types that the release specified in
         *        <code>ListSupportedInstanceTypesInput$ReleaseLabel</code> supports, filtered by Amazon Web Services
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedInstanceTypes(Collection<SupportedInstanceType> supportedInstanceTypes);

        /**
         * <p>
         * The list of instance types that the release specified in
         * <code>ListSupportedInstanceTypesInput$ReleaseLabel</code> supports, filtered by Amazon Web Services Region.
         * </p>
         * 
         * @param supportedInstanceTypes
         *        The list of instance types that the release specified in
         *        <code>ListSupportedInstanceTypesInput$ReleaseLabel</code> supports, filtered by Amazon Web Services
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedInstanceTypes(SupportedInstanceType... supportedInstanceTypes);

        /**
         * <p>
         * The list of instance types that the release specified in
         * <code>ListSupportedInstanceTypesInput$ReleaseLabel</code> supports, filtered by Amazon Web Services Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.SupportedInstanceType.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emr.model.SupportedInstanceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.SupportedInstanceType.Builder#build()} is called immediately
         * and its result is passed to {@link #supportedInstanceTypes(List<SupportedInstanceType>)}.
         * 
         * @param supportedInstanceTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.SupportedInstanceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedInstanceTypes(java.util.Collection<SupportedInstanceType>)
         */
        Builder supportedInstanceTypes(Consumer<SupportedInstanceType.Builder>... supportedInstanceTypes);

        /**
         * <p>
         * The pagination token that marks the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that marks the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<SupportedInstanceType> supportedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupportedInstanceTypesResponse model) {
            super(model);
            supportedInstanceTypes(model.supportedInstanceTypes);
            marker(model.marker);
        }

        public final List<SupportedInstanceType.Builder> getSupportedInstanceTypes() {
            List<SupportedInstanceType.Builder> result = SupportedInstanceTypesListCopier
                    .copyToBuilder(this.supportedInstanceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedInstanceTypes(Collection<SupportedInstanceType.BuilderImpl> supportedInstanceTypes) {
            this.supportedInstanceTypes = SupportedInstanceTypesListCopier.copyFromBuilder(supportedInstanceTypes);
        }

        @Override
        public final Builder supportedInstanceTypes(Collection<SupportedInstanceType> supportedInstanceTypes) {
            this.supportedInstanceTypes = SupportedInstanceTypesListCopier.copy(supportedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInstanceTypes(SupportedInstanceType... supportedInstanceTypes) {
            supportedInstanceTypes(Arrays.asList(supportedInstanceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInstanceTypes(Consumer<SupportedInstanceType.Builder>... supportedInstanceTypes) {
            supportedInstanceTypes(Stream.of(supportedInstanceTypes)
                    .map(c -> SupportedInstanceType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListSupportedInstanceTypesResponse build() {
            return new ListSupportedInstanceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
