/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This input determines which instance groups to retrieve.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstanceGroupsResponse extends EmrResponse implements
        ToCopyableBuilder<ListInstanceGroupsResponse.Builder, ListInstanceGroupsResponse> {
    private static final SdkField<List<InstanceGroup>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<InstanceGroup>> builder(MarshallingType.LIST)
            .memberName("InstanceGroups")
            .getter(getter(ListInstanceGroupsResponse::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListInstanceGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUPS_FIELD,
            MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceGroup> instanceGroups;

    private final String marker;

    private ListInstanceGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceGroups = builder.instanceGroups;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of instance groups for the cluster and given filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroups} method.
     * </p>
     * 
     * @return The list of instance groups for the cluster and given filters.
     */
    public final List<InstanceGroup> instanceGroups() {
        return instanceGroups;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroups() ? instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceGroupsResponse)) {
            return false;
        }
        ListInstanceGroupsResponse other = (ListInstanceGroupsResponse) obj;
        return hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(instanceGroups(), other.instanceGroups())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstanceGroupsResponse")
                .add("InstanceGroups", hasInstanceGroups() ? instanceGroups() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceGroupsResponse, T> g) {
        return obj -> g.apply((ListInstanceGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInstanceGroupsResponse> {
        /**
         * <p>
         * The list of instance groups for the cluster and given filters.
         * </p>
         * 
         * @param instanceGroups
         *        The list of instance groups for the cluster and given filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<InstanceGroup> instanceGroups);

        /**
         * <p>
         * The list of instance groups for the cluster and given filters.
         * </p>
         * 
         * @param instanceGroups
         *        The list of instance groups for the cluster and given filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(InstanceGroup... instanceGroups);

        /**
         * <p>
         * The list of instance groups for the cluster and given filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.InstanceGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.emr.model.InstanceGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.InstanceGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceGroups(List<InstanceGroup>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.InstanceGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(java.util.Collection<InstanceGroup>)
         */
        Builder instanceGroups(Consumer<InstanceGroup.Builder>... instanceGroups);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<InstanceGroup> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceGroupsResponse model) {
            super(model);
            instanceGroups(model.instanceGroups);
            marker(model.marker);
        }

        public final List<InstanceGroup.Builder> getInstanceGroups() {
            List<InstanceGroup.Builder> result = InstanceGroupListCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<InstanceGroup.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupListCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroup> instanceGroups) {
            this.instanceGroups = InstanceGroupListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroup... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroup.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups).map(c -> InstanceGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListInstanceGroupsResponse build() {
            return new ListInstanceGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
