/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.emf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.metrics.MetricCategory;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricLevel;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.metrics.publishers.emf.internal.EmfMetricConfiguration;
import software.amazon.awssdk.metrics.publishers.emf.internal.MetricEmfConverter;
import software.amazon.awssdk.utils.Logger;

@ThreadSafe
@Immutable
@SdkPublicApi
public final class EmfMetricLoggingPublisher
implements MetricPublisher {
    private static final Logger logger = Logger.loggerFor(EmfMetricLoggingPublisher.class);
    private final MetricEmfConverter metricConverter;

    private EmfMetricLoggingPublisher(Builder builder) {
        EmfMetricConfiguration config = new EmfMetricConfiguration.Builder().namespace(builder.namespace).logGroupName(builder.logGroupName).dimensions(builder.dimensions).metricLevel(builder.metricLevel).metricCategories(builder.metricCategories).build();
        this.metricConverter = new MetricEmfConverter(config);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void publish(MetricCollection metricCollection) {
        if (metricCollection == null) {
            logger.warn(() -> "Null metric collection passed to the publisher");
            return;
        }
        try {
            List<String> emfStrings = this.metricConverter.convertMetricCollectionToEmf(metricCollection);
            for (String emfString : emfStrings) {
                logger.info(() -> emfString);
            }
        }
        catch (Exception e) {
            logger.error(() -> "Failed to log metrics in EMF format", (Throwable)e);
        }
    }

    public void close() {
    }

    public static final class Builder {
        private String namespace;
        private String logGroupName;
        private Collection<SdkMetric<String>> dimensions;
        private Collection<MetricCategory> metricCategories;
        private MetricLevel metricLevel;

        private Builder() {
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder dimensions(Collection<SdkMetric<String>> dimensions) {
            this.dimensions = new ArrayList<SdkMetric<String>>(dimensions);
            return this;
        }

        @SafeVarargs
        public final Builder dimensions(SdkMetric<String> ... dimensions) {
            return this.dimensions(Arrays.asList(dimensions));
        }

        public Builder metricCategories(Collection<MetricCategory> metricCategories) {
            this.metricCategories = new ArrayList<MetricCategory>(metricCategories);
            return this;
        }

        public Builder metricCategories(MetricCategory ... metricCategories) {
            return this.metricCategories(Arrays.asList(metricCategories));
        }

        public Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public Builder metricLevel(MetricLevel metricLevel) {
            this.metricLevel = metricLevel;
            return this;
        }

        public EmfMetricLoggingPublisher build() {
            return new EmfMetricLoggingPublisher(this);
        }
    }
}

