/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.emf.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCategory;
import software.amazon.awssdk.metrics.MetricLevel;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.SystemSettingUtils;

@SdkInternalApi
public final class EmfMetricConfiguration {
    private static final String DEFAULT_NAMESPACE = "AwsSdk/JavaSdk2";
    private static final Set<SdkMetric<String>> DEFAULT_DIMENSIONS = Stream.of(CoreMetric.SERVICE_ID, CoreMetric.OPERATION_NAME).collect(Collectors.toSet());
    private static final Set<MetricCategory> DEFAULT_CATEGORIES = Collections.singleton(MetricCategory.ALL);
    private static final MetricLevel DEFAULT_METRIC_LEVEL = MetricLevel.INFO;
    private final String namespace;
    private final String logGroupName;
    private final Set<SdkMetric<String>> dimensions;
    private final Collection<MetricCategory> metricCategories;
    private final MetricLevel metricLevel;

    private EmfMetricConfiguration(Builder builder) {
        this.namespace = builder.namespace == null ? DEFAULT_NAMESPACE : builder.namespace;
        this.logGroupName = (String)Validate.paramNotNull((Object)this.resolveLogGroupName(builder), (String)"logGroupName");
        this.dimensions = builder.dimensions == null ? DEFAULT_DIMENSIONS : new HashSet(builder.dimensions);
        this.metricCategories = builder.metricCategories == null ? DEFAULT_CATEGORIES : new HashSet(builder.metricCategories);
        this.metricLevel = builder.metricLevel == null ? DEFAULT_METRIC_LEVEL : builder.metricLevel;
    }

    public String namespace() {
        return this.namespace;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Collection<SdkMetric<String>> dimensions() {
        return this.dimensions;
    }

    public Collection<MetricCategory> metricCategories() {
        return this.metricCategories;
    }

    public MetricLevel metricLevel() {
        return this.metricLevel;
    }

    private String resolveLogGroupName(Builder builder) {
        return builder.logGroupName != null ? builder.logGroupName : (String)SystemSettingUtils.resolveEnvironmentVariable((String)"AWS_LAMBDA_LOG_GROUP_NAME").orElse(null);
    }

    public static class Builder {
        private String namespace;
        private String logGroupName;
        private Collection<SdkMetric<String>> dimensions;
        private Collection<MetricCategory> metricCategories;
        private MetricLevel metricLevel;

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public Builder dimensions(Collection<SdkMetric<String>> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder metricCategories(Collection<MetricCategory> metricCategories) {
            this.metricCategories = metricCategories;
            return this;
        }

        public Builder metricLevel(MetricLevel metricLevel) {
            this.metricLevel = metricLevel;
            return this;
        }

        public EmfMetricConfiguration build() {
            return new EmfMetricConfiguration(this);
        }
    }
}

