/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elastictranscoder.model.CodecOptionsCopier;
import software.amazon.awssdk.services.elastictranscoder.model.PresetWatermark;
import software.amazon.awssdk.services.elastictranscoder.model.PresetWatermarksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoParameters> {
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(VideoParameters.getter(VideoParameters::codec)).setter(VideoParameters.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codec").build()}).build();
    private static final SdkField<Map<String, String>> CODEC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CodecOptions").getter(VideoParameters.getter(VideoParameters::codecOptions)).setter(VideoParameters.setter(Builder::codecOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodecOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KEYFRAMES_MAX_DIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyframesMaxDist").getter(VideoParameters.getter(VideoParameters::keyframesMaxDist)).setter(VideoParameters.setter(Builder::keyframesMaxDist)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyframesMaxDist").build()}).build();
    private static final SdkField<String> FIXED_GOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FixedGOP").getter(VideoParameters.getter(VideoParameters::fixedGOP)).setter(VideoParameters.setter(Builder::fixedGOP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedGOP").build()}).build();
    private static final SdkField<String> BIT_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitRate").getter(VideoParameters.getter(VideoParameters::bitRate)).setter(VideoParameters.setter(Builder::bitRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitRate").build()}).build();
    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameRate").getter(VideoParameters.getter(VideoParameters::frameRate)).setter(VideoParameters.setter(Builder::frameRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()}).build();
    private static final SdkField<String> MAX_FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxFrameRate").getter(VideoParameters.getter(VideoParameters::maxFrameRate)).setter(VideoParameters.setter(Builder::maxFrameRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFrameRate").build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resolution").getter(VideoParameters.getter(VideoParameters::resolution)).setter(VideoParameters.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resolution").build()}).build();
    private static final SdkField<String> ASPECT_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AspectRatio").getter(VideoParameters.getter(VideoParameters::aspectRatio)).setter(VideoParameters.setter(Builder::aspectRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AspectRatio").build()}).build();
    private static final SdkField<String> MAX_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxWidth").getter(VideoParameters.getter(VideoParameters::maxWidth)).setter(VideoParameters.setter(Builder::maxWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWidth").build()}).build();
    private static final SdkField<String> MAX_HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxHeight").getter(VideoParameters.getter(VideoParameters::maxHeight)).setter(VideoParameters.setter(Builder::maxHeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHeight").build()}).build();
    private static final SdkField<String> DISPLAY_ASPECT_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayAspectRatio").getter(VideoParameters.getter(VideoParameters::displayAspectRatio)).setter(VideoParameters.setter(Builder::displayAspectRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayAspectRatio").build()}).build();
    private static final SdkField<String> SIZING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SizingPolicy").getter(VideoParameters.getter(VideoParameters::sizingPolicy)).setter(VideoParameters.setter(Builder::sizingPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingPolicy").build()}).build();
    private static final SdkField<String> PADDING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaddingPolicy").getter(VideoParameters.getter(VideoParameters::paddingPolicy)).setter(VideoParameters.setter(Builder::paddingPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaddingPolicy").build()}).build();
    private static final SdkField<List<PresetWatermark>> WATERMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Watermarks").getter(VideoParameters.getter(VideoParameters::watermarks)).setter(VideoParameters.setter(Builder::watermarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Watermarks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PresetWatermark::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD, CODEC_OPTIONS_FIELD, KEYFRAMES_MAX_DIST_FIELD, FIXED_GOP_FIELD, BIT_RATE_FIELD, FRAME_RATE_FIELD, MAX_FRAME_RATE_FIELD, RESOLUTION_FIELD, ASPECT_RATIO_FIELD, MAX_WIDTH_FIELD, MAX_HEIGHT_FIELD, DISPLAY_ASPECT_RATIO_FIELD, SIZING_POLICY_FIELD, PADDING_POLICY_FIELD, WATERMARKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String codec;
    private final Map<String, String> codecOptions;
    private final String keyframesMaxDist;
    private final String fixedGOP;
    private final String bitRate;
    private final String frameRate;
    private final String maxFrameRate;
    private final String resolution;
    private final String aspectRatio;
    private final String maxWidth;
    private final String maxHeight;
    private final String displayAspectRatio;
    private final String sizingPolicy;
    private final String paddingPolicy;
    private final List<PresetWatermark> watermarks;

    private VideoParameters(BuilderImpl builder) {
        this.codec = builder.codec;
        this.codecOptions = builder.codecOptions;
        this.keyframesMaxDist = builder.keyframesMaxDist;
        this.fixedGOP = builder.fixedGOP;
        this.bitRate = builder.bitRate;
        this.frameRate = builder.frameRate;
        this.maxFrameRate = builder.maxFrameRate;
        this.resolution = builder.resolution;
        this.aspectRatio = builder.aspectRatio;
        this.maxWidth = builder.maxWidth;
        this.maxHeight = builder.maxHeight;
        this.displayAspectRatio = builder.displayAspectRatio;
        this.sizingPolicy = builder.sizingPolicy;
        this.paddingPolicy = builder.paddingPolicy;
        this.watermarks = builder.watermarks;
    }

    public final String codec() {
        return this.codec;
    }

    public final boolean hasCodecOptions() {
        return this.codecOptions != null && !(this.codecOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> codecOptions() {
        return this.codecOptions;
    }

    public final String keyframesMaxDist() {
        return this.keyframesMaxDist;
    }

    public final String fixedGOP() {
        return this.fixedGOP;
    }

    public final String bitRate() {
        return this.bitRate;
    }

    public final String frameRate() {
        return this.frameRate;
    }

    public final String maxFrameRate() {
        return this.maxFrameRate;
    }

    public final String resolution() {
        return this.resolution;
    }

    public final String aspectRatio() {
        return this.aspectRatio;
    }

    public final String maxWidth() {
        return this.maxWidth;
    }

    public final String maxHeight() {
        return this.maxHeight;
    }

    public final String displayAspectRatio() {
        return this.displayAspectRatio;
    }

    public final String sizingPolicy() {
        return this.sizingPolicy;
    }

    public final String paddingPolicy() {
        return this.paddingPolicy;
    }

    public final boolean hasWatermarks() {
        return this.watermarks != null && !(this.watermarks instanceof SdkAutoConstructList);
    }

    public final List<PresetWatermark> watermarks() {
        return this.watermarks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodecOptions() ? this.codecOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.keyframesMaxDist());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedGOP());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFrameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.aspectRatio());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayAspectRatio());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.paddingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWatermarks() ? this.watermarks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoParameters)) {
            return false;
        }
        VideoParameters other = (VideoParameters)obj;
        return Objects.equals(this.codec(), other.codec()) && this.hasCodecOptions() == other.hasCodecOptions() && Objects.equals(this.codecOptions(), other.codecOptions()) && Objects.equals(this.keyframesMaxDist(), other.keyframesMaxDist()) && Objects.equals(this.fixedGOP(), other.fixedGOP()) && Objects.equals(this.bitRate(), other.bitRate()) && Objects.equals(this.frameRate(), other.frameRate()) && Objects.equals(this.maxFrameRate(), other.maxFrameRate()) && Objects.equals(this.resolution(), other.resolution()) && Objects.equals(this.aspectRatio(), other.aspectRatio()) && Objects.equals(this.maxWidth(), other.maxWidth()) && Objects.equals(this.maxHeight(), other.maxHeight()) && Objects.equals(this.displayAspectRatio(), other.displayAspectRatio()) && Objects.equals(this.sizingPolicy(), other.sizingPolicy()) && Objects.equals(this.paddingPolicy(), other.paddingPolicy()) && this.hasWatermarks() == other.hasWatermarks() && Objects.equals(this.watermarks(), other.watermarks());
    }

    public final String toString() {
        return ToString.builder((String)"VideoParameters").add("Codec", (Object)this.codec()).add("CodecOptions", this.hasCodecOptions() ? this.codecOptions() : null).add("KeyframesMaxDist", (Object)this.keyframesMaxDist()).add("FixedGOP", (Object)this.fixedGOP()).add("BitRate", (Object)this.bitRate()).add("FrameRate", (Object)this.frameRate()).add("MaxFrameRate", (Object)this.maxFrameRate()).add("Resolution", (Object)this.resolution()).add("AspectRatio", (Object)this.aspectRatio()).add("MaxWidth", (Object)this.maxWidth()).add("MaxHeight", (Object)this.maxHeight()).add("DisplayAspectRatio", (Object)this.displayAspectRatio()).add("SizingPolicy", (Object)this.sizingPolicy()).add("PaddingPolicy", (Object)this.paddingPolicy()).add("Watermarks", this.hasWatermarks() ? this.watermarks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "CodecOptions": {
                return Optional.ofNullable(clazz.cast(this.codecOptions()));
            }
            case "KeyframesMaxDist": {
                return Optional.ofNullable(clazz.cast(this.keyframesMaxDist()));
            }
            case "FixedGOP": {
                return Optional.ofNullable(clazz.cast(this.fixedGOP()));
            }
            case "BitRate": {
                return Optional.ofNullable(clazz.cast(this.bitRate()));
            }
            case "FrameRate": {
                return Optional.ofNullable(clazz.cast(this.frameRate()));
            }
            case "MaxFrameRate": {
                return Optional.ofNullable(clazz.cast(this.maxFrameRate()));
            }
            case "Resolution": {
                return Optional.ofNullable(clazz.cast(this.resolution()));
            }
            case "AspectRatio": {
                return Optional.ofNullable(clazz.cast(this.aspectRatio()));
            }
            case "MaxWidth": {
                return Optional.ofNullable(clazz.cast(this.maxWidth()));
            }
            case "MaxHeight": {
                return Optional.ofNullable(clazz.cast(this.maxHeight()));
            }
            case "DisplayAspectRatio": {
                return Optional.ofNullable(clazz.cast(this.displayAspectRatio()));
            }
            case "SizingPolicy": {
                return Optional.ofNullable(clazz.cast(this.sizingPolicy()));
            }
            case "PaddingPolicy": {
                return Optional.ofNullable(clazz.cast(this.paddingPolicy()));
            }
            case "Watermarks": {
                return Optional.ofNullable(clazz.cast(this.watermarks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Codec", CODEC_FIELD);
        map.put("CodecOptions", CODEC_OPTIONS_FIELD);
        map.put("KeyframesMaxDist", KEYFRAMES_MAX_DIST_FIELD);
        map.put("FixedGOP", FIXED_GOP_FIELD);
        map.put("BitRate", BIT_RATE_FIELD);
        map.put("FrameRate", FRAME_RATE_FIELD);
        map.put("MaxFrameRate", MAX_FRAME_RATE_FIELD);
        map.put("Resolution", RESOLUTION_FIELD);
        map.put("AspectRatio", ASPECT_RATIO_FIELD);
        map.put("MaxWidth", MAX_WIDTH_FIELD);
        map.put("MaxHeight", MAX_HEIGHT_FIELD);
        map.put("DisplayAspectRatio", DISPLAY_ASPECT_RATIO_FIELD);
        map.put("SizingPolicy", SIZING_POLICY_FIELD);
        map.put("PaddingPolicy", PADDING_POLICY_FIELD);
        map.put("Watermarks", WATERMARKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoParameters, T> g) {
        return obj -> g.apply((VideoParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codec;
        private Map<String, String> codecOptions = DefaultSdkAutoConstructMap.getInstance();
        private String keyframesMaxDist;
        private String fixedGOP;
        private String bitRate;
        private String frameRate;
        private String maxFrameRate;
        private String resolution;
        private String aspectRatio;
        private String maxWidth;
        private String maxHeight;
        private String displayAspectRatio;
        private String sizingPolicy;
        private String paddingPolicy;
        private List<PresetWatermark> watermarks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VideoParameters model) {
            this.codec(model.codec);
            this.codecOptions(model.codecOptions);
            this.keyframesMaxDist(model.keyframesMaxDist);
            this.fixedGOP(model.fixedGOP);
            this.bitRate(model.bitRate);
            this.frameRate(model.frameRate);
            this.maxFrameRate(model.maxFrameRate);
            this.resolution(model.resolution);
            this.aspectRatio(model.aspectRatio);
            this.maxWidth(model.maxWidth);
            this.maxHeight(model.maxHeight);
            this.displayAspectRatio(model.displayAspectRatio);
            this.sizingPolicy(model.sizingPolicy);
            this.paddingPolicy(model.paddingPolicy);
            this.watermarks(model.watermarks);
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final Map<String, String> getCodecOptions() {
            if (this.codecOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.codecOptions;
        }

        public final void setCodecOptions(Map<String, String> codecOptions) {
            this.codecOptions = CodecOptionsCopier.copy(codecOptions);
        }

        @Override
        public final Builder codecOptions(Map<String, String> codecOptions) {
            this.codecOptions = CodecOptionsCopier.copy(codecOptions);
            return this;
        }

        public final String getKeyframesMaxDist() {
            return this.keyframesMaxDist;
        }

        public final void setKeyframesMaxDist(String keyframesMaxDist) {
            this.keyframesMaxDist = keyframesMaxDist;
        }

        @Override
        public final Builder keyframesMaxDist(String keyframesMaxDist) {
            this.keyframesMaxDist = keyframesMaxDist;
            return this;
        }

        public final String getFixedGOP() {
            return this.fixedGOP;
        }

        public final void setFixedGOP(String fixedGOP) {
            this.fixedGOP = fixedGOP;
        }

        @Override
        public final Builder fixedGOP(String fixedGOP) {
            this.fixedGOP = fixedGOP;
            return this;
        }

        public final String getBitRate() {
            return this.bitRate;
        }

        public final void setBitRate(String bitRate) {
            this.bitRate = bitRate;
        }

        @Override
        public final Builder bitRate(String bitRate) {
            this.bitRate = bitRate;
            return this;
        }

        public final String getFrameRate() {
            return this.frameRate;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final String getMaxFrameRate() {
            return this.maxFrameRate;
        }

        public final void setMaxFrameRate(String maxFrameRate) {
            this.maxFrameRate = maxFrameRate;
        }

        @Override
        public final Builder maxFrameRate(String maxFrameRate) {
            this.maxFrameRate = maxFrameRate;
            return this;
        }

        public final String getResolution() {
            return this.resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final String getAspectRatio() {
            return this.aspectRatio;
        }

        public final void setAspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        @Override
        public final Builder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public final String getMaxWidth() {
            return this.maxWidth;
        }

        public final void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public final Builder maxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public final String getMaxHeight() {
            return this.maxHeight;
        }

        public final void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public final Builder maxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public final String getDisplayAspectRatio() {
            return this.displayAspectRatio;
        }

        public final void setDisplayAspectRatio(String displayAspectRatio) {
            this.displayAspectRatio = displayAspectRatio;
        }

        @Override
        public final Builder displayAspectRatio(String displayAspectRatio) {
            this.displayAspectRatio = displayAspectRatio;
            return this;
        }

        public final String getSizingPolicy() {
            return this.sizingPolicy;
        }

        public final void setSizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
        }

        @Override
        public final Builder sizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
            return this;
        }

        public final String getPaddingPolicy() {
            return this.paddingPolicy;
        }

        public final void setPaddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
        }

        @Override
        public final Builder paddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
            return this;
        }

        public final List<PresetWatermark.Builder> getWatermarks() {
            List<PresetWatermark.Builder> result = PresetWatermarksCopier.copyToBuilder(this.watermarks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatermarks(Collection<PresetWatermark.BuilderImpl> watermarks) {
            this.watermarks = PresetWatermarksCopier.copyFromBuilder(watermarks);
        }

        @Override
        public final Builder watermarks(Collection<PresetWatermark> watermarks) {
            this.watermarks = PresetWatermarksCopier.copy(watermarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(PresetWatermark ... watermarks) {
            this.watermarks(Arrays.asList(watermarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(Consumer<PresetWatermark.Builder> ... watermarks) {
            this.watermarks(Stream.of(watermarks).map(c -> (PresetWatermark)((PresetWatermark.Builder)PresetWatermark.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VideoParameters build() {
            return new VideoParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoParameters> {
        public Builder codec(String var1);

        public Builder codecOptions(Map<String, String> var1);

        public Builder keyframesMaxDist(String var1);

        public Builder fixedGOP(String var1);

        public Builder bitRate(String var1);

        public Builder frameRate(String var1);

        public Builder maxFrameRate(String var1);

        public Builder resolution(String var1);

        public Builder aspectRatio(String var1);

        public Builder maxWidth(String var1);

        public Builder maxHeight(String var1);

        public Builder displayAspectRatio(String var1);

        public Builder sizingPolicy(String var1);

        public Builder paddingPolicy(String var1);

        public Builder watermarks(Collection<PresetWatermark> var1);

        public Builder watermarks(PresetWatermark ... var1);

        public Builder watermarks(Consumer<PresetWatermark.Builder> ... var1);
    }
}

