/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Preset;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePresetResponse
extends ElasticTranscoderResponse
implements ToCopyableBuilder<Builder, CreatePresetResponse> {
    private static final SdkField<Preset> PRESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Preset").getter(CreatePresetResponse.getter(CreatePresetResponse::preset)).setter(CreatePresetResponse.setter(Builder::preset)).constructor(Preset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preset").build()}).build();
    private static final SdkField<String> WARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Warning").getter(CreatePresetResponse.getter(CreatePresetResponse::warning)).setter(CreatePresetResponse.setter(Builder::warning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESET_FIELD, WARNING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePresetResponse.memberNameToFieldInitializer();
    private final Preset preset;
    private final String warning;

    private CreatePresetResponse(BuilderImpl builder) {
        super(builder);
        this.preset = builder.preset;
        this.warning = builder.warning;
    }

    public final Preset preset() {
        return this.preset;
    }

    public final String warning() {
        return this.warning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.preset());
        hashCode = 31 * hashCode + Objects.hashCode(this.warning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresetResponse)) {
            return false;
        }
        CreatePresetResponse other = (CreatePresetResponse)((Object)obj);
        return Objects.equals(this.preset(), other.preset()) && Objects.equals(this.warning(), other.warning());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePresetResponse").add("Preset", (Object)this.preset()).add("Warning", (Object)this.warning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Preset": {
                return Optional.ofNullable(clazz.cast(this.preset()));
            }
            case "Warning": {
                return Optional.ofNullable(clazz.cast(this.warning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Preset", PRESET_FIELD);
        map.put("Warning", WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePresetResponse, T> g) {
        return obj -> g.apply((CreatePresetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderResponse.BuilderImpl
    implements Builder {
        private Preset preset;
        private String warning;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresetResponse model) {
            super(model);
            this.preset(model.preset);
            this.warning(model.warning);
        }

        public final Preset.Builder getPreset() {
            return this.preset != null ? this.preset.toBuilder() : null;
        }

        public final void setPreset(Preset.BuilderImpl preset) {
            this.preset = preset != null ? preset.build() : null;
        }

        @Override
        public final Builder preset(Preset preset) {
            this.preset = preset;
            return this;
        }

        public final String getWarning() {
            return this.warning;
        }

        public final void setWarning(String warning) {
            this.warning = warning;
        }

        @Override
        public final Builder warning(String warning) {
            this.warning = warning;
            return this;
        }

        @Override
        public CreatePresetResponse build() {
            return new CreatePresetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticTranscoderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePresetResponse> {
        public Builder preset(Preset var1);

        default public Builder preset(Consumer<Preset.Builder> preset) {
            return this.preset((Preset)((Preset.Builder)Preset.builder().applyMutation(preset)).build());
        }

        public Builder warning(String var1);
    }
}

