/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Pipeline;
import software.amazon.awssdk.services.elastictranscoder.model.Warning;
import software.amazon.awssdk.services.elastictranscoder.model.WarningsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipelineResponse
extends ElasticTranscoderResponse
implements ToCopyableBuilder<Builder, UpdatePipelineResponse> {
    private static final SdkField<Pipeline> PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pipeline").getter(UpdatePipelineResponse.getter(UpdatePipelineResponse::pipeline)).setter(UpdatePipelineResponse.setter(Builder::pipeline)).constructor(Pipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipeline").build()}).build();
    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(UpdatePipelineResponse.getter(UpdatePipelineResponse::warnings)).setter(UpdatePipelineResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Warning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_FIELD, WARNINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePipelineResponse.memberNameToFieldInitializer();
    private final Pipeline pipeline;
    private final List<Warning> warnings;

    private UpdatePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
        this.warnings = builder.warnings;
    }

    public final Pipeline pipeline() {
        return this.pipeline;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<Warning> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineResponse)) {
            return false;
        }
        UpdatePipelineResponse other = (UpdatePipelineResponse)((Object)obj);
        return Objects.equals(this.pipeline(), other.pipeline()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipelineResponse").add("Pipeline", (Object)this.pipeline()).add("Warnings", this.hasWarnings() ? this.warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pipeline": {
                return Optional.ofNullable(clazz.cast(this.pipeline()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Pipeline", PIPELINE_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineResponse, T> g) {
        return obj -> g.apply((UpdatePipelineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderResponse.BuilderImpl
    implements Builder {
        private Pipeline pipeline;
        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineResponse model) {
            super(model);
            this.pipeline(model.pipeline);
            this.warnings(model.warnings);
        }

        public final Pipeline.Builder getPipeline() {
            return this.pipeline != null ? this.pipeline.toBuilder() : null;
        }

        public final void setPipeline(Pipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public final Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final List<Warning.Builder> getWarnings() {
            List<Warning.Builder> result = WarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (Warning)((Warning.Builder)Warning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdatePipelineResponse build() {
            return new UpdatePipelineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticTranscoderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipelineResponse> {
        public Builder pipeline(Pipeline var1);

        default public Builder pipeline(Consumer<Pipeline.Builder> pipeline) {
            return this.pipeline((Pipeline)((Pipeline.Builder)Pipeline.builder().applyMutation(pipeline)).build());
        }

        public Builder warnings(Collection<Warning> var1);

        public Builder warnings(Warning ... var1);

        public Builder warnings(Consumer<Warning.Builder> ... var1);
    }
}

